//var webdeveloper_accessibilityValidator = new WebDeveloperValidateAccessibility();
var webdeveloper_cssValidator           = new WebDeveloperValidateCSS();
var webdeveloper_htmlValidator          = new WebDeveloperValidateHTML();
var webdeveloper_selectedValidationTab  = -1;

// Clears the accessibility validation details for the page
function webdeveloper_clearPageAccessibilityValidation()
{
    var validationButton = document.getElementById("webdeveloper-accessibility-validation");

    // If the validation button is set
    if(validationButton)
    {
        validationButton.label = "";

        // If the validation button has a class attribute
        if(validationButton.hasAttribute("class"))
        {
            validationButton.removeAttribute("class");
        }
    }

    webdeveloper_accessibilityValidator.cleanUp();
}

// Clears the CSS validation details for the page
function webdeveloper_clearPageCSSValidation()
{
    var validationButton = document.getElementById("webdeveloper-css-validation");

    // If the validation button is set
    if(validationButton)
    {
        validationButton.label = "";

        // If the validation button has a class attribute
        if(validationButton.hasAttribute("class"))
        {
            validationButton.removeAttribute("class");
        }
    }

    webdeveloper_cssValidator.cleanUp();
}

// Clears the HTML validation details for the page
function webdeveloper_clearPageHTMLValidation()
{
    var validationButton = document.getElementById("webdeveloper-html-validation");

    // If the validation button is set
    if(validationButton)
    {
        validationButton.label = "";

        // If the validation button has a class attribute
        if(validationButton.hasAttribute("class"))
        {
            validationButton.removeAttribute("class");
        }
    }

    webdeveloper_htmlValidator.cleanUp();
}

// Displays page validation
function webdeveloper_displayPageValidation(element)
{
    var checked       = false;
    var windowContent = window.getBrowser();

    // If the element is set
    if(element)
    {
        checked = webdeveloper_convertToBoolean(element.getAttribute("checked"));
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-page-validation-toolbar"), "hidden", !checked);

    // If the window content is set
    if(windowContent)
    {
        var tabBox = windowContent.mTabBox;

        //webdeveloper_clearPageAccessibilityValidation();
        webdeveloper_clearPageCSSValidation();
        webdeveloper_clearPageHTMLValidation();

        // If displaying page validation
        if(checked)
        {
            var contentDocument = webdeveloper_getContentDocument();

            //webdeveloper_updatePageAccessibilityValidation(contentDocument);
            webdeveloper_updatePageCSSValidation(contentDocument);
            webdeveloper_updatePageHTMLValidation(contentDocument);

            windowContent.addEventListener("load", webdeveloper_pageValidationPageLoad, true);
            windowContent.addEventListener("unload", webdeveloper_pageValidationPageUnload, true);

            // If the tab box is set
            if(tabBox)
            {
                tabBox.addEventListener("select", webdeveloper_pageValidationTabSelect, false);
            }
        }
        else
        {
            // Try to remove the event listener
            try
            {
                windowContent.removeEventListener("load", webdeveloper_pageValidationPageLoad, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            // Try to remove the event listener
            try
            {
                windowContent.removeEventListener("unload", webdeveloper_pageValidationPageUnload, true);
            }
            catch(exception)
            {
                // Do nothing
            }

            // If the tab box is set
            if(tabBox)
            {
                // Try to remove the event listener
                try
                {
                    tabBox.removeEventListener("select", webdeveloper_pageValidationTabSelect, false);
                }
                catch(exception)
                {
                    // Do nothing
                }
            }
        }
    }

    webdeveloper_toggleAppliedStyle(element, "webdeveloper-display-page-validation");
}

// Checks if the page is validatable
function webdeveloper_isValidatablePage(uri)
{
    // If the URI is set and is validatable
    if(uri && uri != "about:blank" && uri != "http://www.hermish.com/check_this.cfm" && uri != "http://jigsaw.w3.org/css-validator/validator" && uri != "http://validator.w3.org/check")
    {
        return true;
    }

    return false;
}

// Handles the page being loaded
function webdeveloper_pageValidationPageLoad(event)
{
    var contentDocument = webdeveloper_getPageLoadEventContentDocument(event);

    // If the content document is set
    if(contentDocument)
    {
        //webdeveloper_clearPageAccessibilityValidation();
        webdeveloper_clearPageCSSValidation();
        webdeveloper_clearPageHTMLValidation();

        // If the page is validatable
        if(webdeveloper_isValidatablePage(contentDocument.documentURI))
        {
            //webdeveloper_updatePageAccessibilityValidation(contentDocument);
            webdeveloper_updatePageCSSValidation(contentDocument);
            webdeveloper_updatePageHTMLValidation(contentDocument);
        }
    }
}

// Handles the page being unloaded
function webdeveloper_pageValidationPageUnload(event)
{
    var contentDocument = webdeveloper_getPageLoadEventContentDocument(event);

    // If the content document is set
    if(contentDocument)
    {
        //webdeveloper_clearPageAccessibilityValidation();
        webdeveloper_clearPageCSSValidation();
        webdeveloper_clearPageHTMLValidation();
    }
}

// Handles a tab being selected
function webdeveloper_pageValidationTabSelect(event)
{
    var selectedTab = getBrowser().mTabBox.selectedIndex;

    // If the selected tab is different
    if(selectedTab != webdeveloper_selectedValidationTab)
    {
        var contentDocument = webdeveloper_getContentDocument();

        webdeveloper_selectedValidationTab = selectedTab;

        //webdeveloper_clearPageAccessibilityValidation();
        webdeveloper_clearPageCSSValidation();
        webdeveloper_clearPageHTMLValidation();
        //webdeveloper_updatePageAccessibilityValidation(contentDocument);
        webdeveloper_updatePageCSSValidation(contentDocument);
        webdeveloper_updatePageHTMLValidation(contentDocument);
    }
}

// Updates the accessibility validation for the page
function webdeveloper_updatePageAccessibilityValidation(contentDocument)
{
    var validationButton = document.getElementById("webdeveloper-accessibility-validation");

    // If the validation button is set
    if(validationButton)
    {
        webdeveloper_accessibilityValidator.cleanUp();
        webdeveloper_accessibilityValidator.validateBackgroundAccessibility(Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newURI(contentDocument.documentURI, null, null));

        validationButton.label = document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_validating");
    }
}

// Updates the accessibility validation details for the page
function webdeveloper_updatePageAccessibilityValidationDetails()
{
    // If the accessibility validation request is set and is ready
    if(webdeveloper_accessibilityValidator.validationRequest && webdeveloper_accessibilityValidator.validationRequest.readyState == 4)
    {
        // Try to check the accessibility validation status
        try
        {
            // If the accessibility validation status is set to success
            if(webdeveloper_accessibilityValidator.validationRequest.status == 200)
            {
                var errors           = webdeveloper_accessibilityValidator.parseValidationResultsByType("violation");
                var validationButton = document.getElementById("webdeveloper-accessibility-validation");
                var warnings         = webdeveloper_accessibilityValidator.parseValidationResultsByType("caution");

                // If the validation button is set
                if(validationButton)
                {
                    var stringBundle = document.getElementById("webdeveloper-string-bundle");

                    // If there are errors
                    if(errors > 0)
                    {
                        var labelValue = stringBundle.getString("webdeveloper_invalid") + ": " + errors + " " + stringBundle.getString("webdeveloper_errors").toLowerCase();

                        // If there are warnings
                        if(warnings > 0)
                        {
                            labelValue += ", " + warnings + " " + stringBundle.getString("webdeveloper_warnings").toLowerCase();
                        }

                        validationButton.label = labelValue;

                        validationButton.setAttribute("class", "error");
                    }
                    else if(warnings > 0)
                    {
                        validationButton.label = stringBundle.getString("webdeveloper_warning") + ": " + warnings + " " + stringBundle.getString("webdeveloper_warnings").toLowerCase();

                        validationButton.setAttribute("class", "warning");
                    }
                    else
                    {
                        validationButton.label = stringBundle.getString("webdeveloper_valid");

                        validationButton.setAttribute("class", "valid");
                    }
                }
            }
        }
        catch(exception)
        {
            // Do nothing
        }

        webdeveloper_accessibilityValidator.cleanUp();
    }
}

// Updates the CSS validation for the page
function webdeveloper_updatePageCSSValidation(contentDocument)
{
    var validationButton = document.getElementById("webdeveloper-css-validation");

    // If the validation button is set
    if(validationButton)
    {
        webdeveloper_cssValidator.cleanUp();
        webdeveloper_cssValidator.validateBackgroundCSS(Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newURI(contentDocument.documentURI, null, null), webdeveloper_getDocuments(webdeveloper_getContentWindow()));

        validationButton.label = document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_validating");
    }
}

// Updates the CSS validation details for the page
function webdeveloper_updatePageCSSValidationDetails()
{
    // If the CSS validation request is set and is ready
    if(webdeveloper_cssValidator.validationRequest && webdeveloper_cssValidator.validationRequest.readyState == 4)
    {
        // Try to check the CSS validation status
        try
        {
            // If the CSS validation status is set to success
            if(webdeveloper_cssValidator.validationRequest.status == 200)
            {
                var errors           = webdeveloper_cssValidator.parseValidationResultsByType("errors");
                var validationButton = document.getElementById("webdeveloper-css-validation");
                var warnings         = webdeveloper_cssValidator.parseValidationResultsByType("warnings");

                // If the validation button is set
                if(validationButton)
                {
                    var stringBundle = document.getElementById("webdeveloper-string-bundle");

                    // If there are errors
                    if(errors > 0)
                    {
                        var labelValue = stringBundle.getString("webdeveloper_invalid") + ": " + errors + " " + stringBundle.getString("webdeveloper_errors").toLowerCase();

                        // If there are warnings
                        if(warnings > 0)
                        {
                            labelValue += ", " + warnings + " " + stringBundle.getString("webdeveloper_warnings").toLowerCase();
                        }

                        validationButton.label = labelValue;

                        validationButton.setAttribute("class", "error");
                    }
                    else if(warnings > 0)
                    {
                        validationButton.label = stringBundle.getString("webdeveloper_warning") + ": " + warnings + " " + stringBundle.getString("webdeveloper_warnings").toLowerCase();

                        validationButton.setAttribute("class", "warning");
                    }
                    else
                    {
                        validationButton.label = stringBundle.getString("webdeveloper_valid");

                        validationButton.setAttribute("class", "valid");
                    }
                }
            }
        }
        catch(exception)
        {
            // Do nothing
        }

        webdeveloper_cssValidator.cleanUp();
    }
}

// Updates the HTML validation for the page
function webdeveloper_updatePageHTMLValidation(contentDocument)
{
    var validationButton = document.getElementById("webdeveloper-html-validation");

    // If the validation button is set
    if(validationButton)
    {
        webdeveloper_htmlValidator.cleanUp();
        webdeveloper_htmlValidator.validateBackgroundHTML(Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newURI(contentDocument.documentURI, null, null));

        validationButton.label = document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_validating");
    }
}

// Updates the HTML validation details for the page
function webdeveloper_updatePageHTMLValidationDetails()
{
    // If the HTML validation request is set and is ready
    if(webdeveloper_htmlValidator.validationRequest && webdeveloper_htmlValidator.validationRequest.readyState == 4)
    {
        // Try to check the HTML validation status
        try
        {
            // If the HTML validation status is set to success
            if(webdeveloper_htmlValidator.validationRequest.status == 200)
            {
                var validationButton = document.getElementById("webdeveloper-html-validation");
                var validationStatus = webdeveloper_htmlValidator.validationRequest.getResponseHeader("X-W3C-Validator-Status");

                // If the validation button and validation status are set
                if(validationButton && validationStatus)
                {
                    var stringBundle = document.getElementById("webdeveloper-string-bundle");

                    // If the validation status is valid
                    if(validationStatus == "Valid")
                    {
                        validationButton.label = stringBundle.getString("webdeveloper_valid");

                        validationButton.setAttribute("class", "valid");
                    }
                    else
                    {
                        validationButton.label = stringBundle.getString("webdeveloper_invalid") + ": " + webdeveloper_htmlValidator.validationRequest.getResponseHeader("X-W3C-Validator-Errors") + " " + stringBundle.getString("webdeveloper_errors").toLowerCase();

                        validationButton.setAttribute("class", "invalid");
                    }
                }
            }
        }
        catch(exception)
        {
            // Do nothing
        }

        webdeveloper_htmlValidator.cleanUp();
    }
}
