/* gesture-event.c generated by valac 0.10.0, the Vala compiler
 * generated from gesture-event.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define UNITY_GESTURE_TYPE_TYPE (unity_gesture_type_get_type ())

#define UNITY_GESTURE_TYPE_STATE (unity_gesture_state_get_type ())

#define UNITY_GESTURE_TYPE_EVENT (unity_gesture_event_get_type ())
#define UNITY_GESTURE_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_GESTURE_TYPE_EVENT, UnityGestureEvent))
#define UNITY_GESTURE_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_GESTURE_TYPE_EVENT, UnityGestureEventClass))
#define UNITY_GESTURE_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_GESTURE_TYPE_EVENT))
#define UNITY_GESTURE_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_GESTURE_TYPE_EVENT))
#define UNITY_GESTURE_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_GESTURE_TYPE_EVENT, UnityGestureEventClass))

typedef struct _UnityGestureEvent UnityGestureEvent;
typedef struct _UnityGestureEventClass UnityGestureEventClass;
typedef struct _UnityGestureEventPrivate UnityGestureEventPrivate;

#define UNITY_GESTURE_TYPE_PAN_EVENT (unity_gesture_pan_event_get_type ())
#define UNITY_GESTURE_PAN_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_GESTURE_TYPE_PAN_EVENT, UnityGesturePanEvent))
#define UNITY_GESTURE_PAN_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_GESTURE_TYPE_PAN_EVENT, UnityGesturePanEventClass))
#define UNITY_GESTURE_IS_PAN_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_GESTURE_TYPE_PAN_EVENT))
#define UNITY_GESTURE_IS_PAN_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_GESTURE_TYPE_PAN_EVENT))
#define UNITY_GESTURE_PAN_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_GESTURE_TYPE_PAN_EVENT, UnityGesturePanEventClass))

typedef struct _UnityGesturePanEvent UnityGesturePanEvent;
typedef struct _UnityGesturePanEventClass UnityGesturePanEventClass;

#define UNITY_GESTURE_TYPE_PINCH_EVENT (unity_gesture_pinch_event_get_type ())
#define UNITY_GESTURE_PINCH_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_GESTURE_TYPE_PINCH_EVENT, UnityGesturePinchEvent))
#define UNITY_GESTURE_PINCH_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_GESTURE_TYPE_PINCH_EVENT, UnityGesturePinchEventClass))
#define UNITY_GESTURE_IS_PINCH_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_GESTURE_TYPE_PINCH_EVENT))
#define UNITY_GESTURE_IS_PINCH_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_GESTURE_TYPE_PINCH_EVENT))
#define UNITY_GESTURE_PINCH_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_GESTURE_TYPE_PINCH_EVENT, UnityGesturePinchEventClass))

typedef struct _UnityGesturePinchEvent UnityGesturePinchEvent;
typedef struct _UnityGesturePinchEventClass UnityGesturePinchEventClass;

#define UNITY_GESTURE_TYPE_TAP_EVENT (unity_gesture_tap_event_get_type ())
#define UNITY_GESTURE_TAP_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_GESTURE_TYPE_TAP_EVENT, UnityGestureTapEvent))
#define UNITY_GESTURE_TAP_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_GESTURE_TYPE_TAP_EVENT, UnityGestureTapEventClass))
#define UNITY_GESTURE_IS_TAP_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_GESTURE_TYPE_TAP_EVENT))
#define UNITY_GESTURE_IS_TAP_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_GESTURE_TYPE_TAP_EVENT))
#define UNITY_GESTURE_TAP_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_GESTURE_TYPE_TAP_EVENT, UnityGestureTapEventClass))

typedef struct _UnityGestureTapEvent UnityGestureTapEvent;
typedef struct _UnityGestureTapEventClass UnityGestureTapEventClass;
#define _unity_gesture_pan_event_unref0(var) ((var == NULL) ? NULL : (var = (unity_gesture_pan_event_unref (var), NULL)))
#define _unity_gesture_pinch_event_unref0(var) ((var == NULL) ? NULL : (var = (unity_gesture_pinch_event_unref (var), NULL)))
#define _unity_gesture_tap_event_unref0(var) ((var == NULL) ? NULL : (var = (unity_gesture_tap_event_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityGesturePanEventPrivate UnityGesturePanEventPrivate;
typedef struct _UnityGesturePinchEventPrivate UnityGesturePinchEventPrivate;
typedef struct _UnityGestureTapEventPrivate UnityGestureTapEventPrivate;
typedef struct _UnityGestureParamSpecEvent UnityGestureParamSpecEvent;
typedef struct _UnityGestureParamSpecPanEvent UnityGestureParamSpecPanEvent;
typedef struct _UnityGestureParamSpecPinchEvent UnityGestureParamSpecPinchEvent;
typedef struct _UnityGestureParamSpecTapEvent UnityGestureParamSpecTapEvent;

typedef enum  {
	UNITY_GESTURE_TYPE_NONE,
	UNITY_GESTURE_TYPE_PAN,
	UNITY_GESTURE_TYPE_PINCH,
	UNITY_GESTURE_TYPE_ROTATE,
	UNITY_GESTURE_TYPE_TAP
} UnityGestureType;

typedef enum  {
	UNITY_GESTURE_STATE_BEGAN,
	UNITY_GESTURE_STATE_CONTINUED,
	UNITY_GESTURE_STATE_ENDED
} UnityGestureState;

struct _UnityGestureEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGestureEventPrivate * priv;
	UnityGestureType type;
	guint32 device_id;
	guint32 gesture_id;
	guint32 timestamp;
	UnityGestureState state;
	gint32 fingers;
	float root_x;
	float root_y;
	Window root_window;
	Window event_window;
	Window child_window;
	UnityGesturePanEvent* pan_event;
	UnityGesturePinchEvent* pinch_event;
	UnityGestureTapEvent* tap_event;
};

struct _UnityGestureEventClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGestureEvent *self);
};

struct _UnityGesturePanEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGesturePanEventPrivate * priv;
	float delta_x;
	float delta_y;
	float velocity_x;
	float velocity_y;
	float x;
	float y;
	float current_n_fingers;
};

struct _UnityGesturePanEventClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGesturePanEvent *self);
};

struct _UnityGesturePinchEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGesturePinchEventPrivate * priv;
	float radius_delta;
	float radius_velocity;
	float radius;
	float bounding_box_x1;
	float bounding_box_y1;
	float bounding_box_x2;
	float bounding_box_y2;
};

struct _UnityGesturePinchEventClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGesturePinchEvent *self);
};

struct _UnityGestureTapEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UnityGestureTapEventPrivate * priv;
	float duration;
	float x2;
	float y2;
};

struct _UnityGestureTapEventClass {
	GTypeClass parent_class;
	void (*finalize) (UnityGestureTapEvent *self);
};

struct _UnityGestureParamSpecEvent {
	GParamSpec parent_instance;
};

struct _UnityGestureParamSpecPanEvent {
	GParamSpec parent_instance;
};

struct _UnityGestureParamSpecPinchEvent {
	GParamSpec parent_instance;
};

struct _UnityGestureParamSpecTapEvent {
	GParamSpec parent_instance;
};


static gpointer unity_gesture_event_parent_class = NULL;
static gpointer unity_gesture_pan_event_parent_class = NULL;
static gpointer unity_gesture_pinch_event_parent_class = NULL;
static gpointer unity_gesture_tap_event_parent_class = NULL;

GType unity_gesture_type_get_type (void) G_GNUC_CONST;
GType unity_gesture_state_get_type (void) G_GNUC_CONST;
gpointer unity_gesture_event_ref (gpointer instance);
void unity_gesture_event_unref (gpointer instance);
GParamSpec* unity_gesture_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_gesture_value_set_event (GValue* value, gpointer v_object);
void unity_gesture_value_take_event (GValue* value, gpointer v_object);
gpointer unity_gesture_value_get_event (const GValue* value);
GType unity_gesture_event_get_type (void) G_GNUC_CONST;
gpointer unity_gesture_pan_event_ref (gpointer instance);
void unity_gesture_pan_event_unref (gpointer instance);
GParamSpec* unity_gesture_param_spec_pan_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_gesture_value_set_pan_event (GValue* value, gpointer v_object);
void unity_gesture_value_take_pan_event (GValue* value, gpointer v_object);
gpointer unity_gesture_value_get_pan_event (const GValue* value);
GType unity_gesture_pan_event_get_type (void) G_GNUC_CONST;
gpointer unity_gesture_pinch_event_ref (gpointer instance);
void unity_gesture_pinch_event_unref (gpointer instance);
GParamSpec* unity_gesture_param_spec_pinch_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_gesture_value_set_pinch_event (GValue* value, gpointer v_object);
void unity_gesture_value_take_pinch_event (GValue* value, gpointer v_object);
gpointer unity_gesture_value_get_pinch_event (const GValue* value);
GType unity_gesture_pinch_event_get_type (void) G_GNUC_CONST;
gpointer unity_gesture_tap_event_ref (gpointer instance);
void unity_gesture_tap_event_unref (gpointer instance);
GParamSpec* unity_gesture_param_spec_tap_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_gesture_value_set_tap_event (GValue* value, gpointer v_object);
void unity_gesture_value_take_tap_event (GValue* value, gpointer v_object);
gpointer unity_gesture_value_get_tap_event (const GValue* value);
GType unity_gesture_tap_event_get_type (void) G_GNUC_CONST;
enum  {
	UNITY_GESTURE_EVENT_DUMMY_PROPERTY
};
char* unity_gesture_event_to_string (UnityGestureEvent* self);
char* unity_gesture_event_type_to_string (UnityGestureType type);
char* unity_gesture_event_state_to_string (UnityGestureState state);
UnityGestureEvent* unity_gesture_event_new (void);
UnityGestureEvent* unity_gesture_event_construct (GType object_type);
static void unity_gesture_event_finalize (UnityGestureEvent* obj);
enum  {
	UNITY_GESTURE_PAN_EVENT_DUMMY_PROPERTY
};
UnityGesturePanEvent* unity_gesture_pan_event_new (void);
UnityGesturePanEvent* unity_gesture_pan_event_construct (GType object_type);
static void unity_gesture_pan_event_finalize (UnityGesturePanEvent* obj);
enum  {
	UNITY_GESTURE_PINCH_EVENT_DUMMY_PROPERTY
};
UnityGesturePinchEvent* unity_gesture_pinch_event_new (void);
UnityGesturePinchEvent* unity_gesture_pinch_event_construct (GType object_type);
static void unity_gesture_pinch_event_finalize (UnityGesturePinchEvent* obj);
enum  {
	UNITY_GESTURE_TAP_EVENT_DUMMY_PROPERTY
};
UnityGestureTapEvent* unity_gesture_tap_event_new (void);
UnityGestureTapEvent* unity_gesture_tap_event_construct (GType object_type);
static void unity_gesture_tap_event_finalize (UnityGestureTapEvent* obj);



GType unity_gesture_type_get_type (void) {
	static volatile gsize unity_gesture_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gesture_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_GESTURE_TYPE_NONE, "UNITY_GESTURE_TYPE_NONE", "none"}, {UNITY_GESTURE_TYPE_PAN, "UNITY_GESTURE_TYPE_PAN", "pan"}, {UNITY_GESTURE_TYPE_PINCH, "UNITY_GESTURE_TYPE_PINCH", "pinch"}, {UNITY_GESTURE_TYPE_ROTATE, "UNITY_GESTURE_TYPE_ROTATE", "rotate"}, {UNITY_GESTURE_TYPE_TAP, "UNITY_GESTURE_TYPE_TAP", "tap"}, {0, NULL, NULL}};
		GType unity_gesture_type_type_id;
		unity_gesture_type_type_id = g_enum_register_static ("UnityGestureType", values);
		g_once_init_leave (&unity_gesture_type_type_id__volatile, unity_gesture_type_type_id);
	}
	return unity_gesture_type_type_id__volatile;
}


GType unity_gesture_state_get_type (void) {
	static volatile gsize unity_gesture_state_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gesture_state_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_GESTURE_STATE_BEGAN, "UNITY_GESTURE_STATE_BEGAN", "began"}, {UNITY_GESTURE_STATE_CONTINUED, "UNITY_GESTURE_STATE_CONTINUED", "continued"}, {UNITY_GESTURE_STATE_ENDED, "UNITY_GESTURE_STATE_ENDED", "ended"}, {0, NULL, NULL}};
		GType unity_gesture_state_type_id;
		unity_gesture_state_type_id = g_enum_register_static ("UnityGestureState", values);
		g_once_init_leave (&unity_gesture_state_type_id__volatile, unity_gesture_state_type_id);
	}
	return unity_gesture_state_type_id__volatile;
}


char* unity_gesture_event_to_string (UnityGestureEvent* self) {
	char* result = NULL;
	char* ret;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	char* _tmp15_;
	char* _tmp16_;
	char* _tmp17_;
	char* _tmp18_;
	char* _tmp19_;
	char* _tmp20_;
	char* _tmp21_;
	char* _tmp22_;
	char* _tmp23_;
	char* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = g_strdup ("");
	ret = (_tmp2_ = g_strconcat (ret, _tmp1_ = g_strconcat (_tmp0_ = unity_gesture_event_type_to_string (self->type), " Gesture\n", NULL), NULL), _g_free0 (ret), _tmp2_);
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
	ret = (_tmp4_ = g_strconcat (ret, _tmp3_ = g_strdup_printf ("\tDevice ID  : %u\n", (guint) self->device_id), NULL), _g_free0 (ret), _tmp4_);
	_g_free0 (_tmp3_);
	ret = (_tmp6_ = g_strconcat (ret, _tmp5_ = g_strdup_printf ("\tGesture ID : %u\n", (guint) self->gesture_id), NULL), _g_free0 (ret), _tmp6_);
	_g_free0 (_tmp5_);
	ret = (_tmp8_ = g_strconcat (ret, _tmp7_ = g_strdup_printf ("\tTimestamp  : %u\n", (guint) self->timestamp), NULL), _g_free0 (ret), _tmp8_);
	_g_free0 (_tmp7_);
	ret = (_tmp12_ = g_strconcat (ret, _tmp11_ = g_strconcat (_tmp10_ = g_strconcat ("\tState      : ", _tmp9_ = unity_gesture_event_state_to_string (self->state), NULL), "\n", NULL), NULL), _g_free0 (ret), _tmp12_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp9_);
	ret = (_tmp14_ = g_strconcat (ret, _tmp13_ = g_strdup_printf ("\tFingers    : %u\n", (guint) self->fingers), NULL), _g_free0 (ret), _tmp14_);
	_g_free0 (_tmp13_);
	ret = (_tmp16_ = g_strconcat (ret, _tmp15_ = g_strdup_printf ("\tX Root     : %f\n", (double) self->root_x), NULL), _g_free0 (ret), _tmp16_);
	_g_free0 (_tmp15_);
	ret = (_tmp18_ = g_strconcat (ret, _tmp17_ = g_strdup_printf ("\tY Root     : %f\n", (double) self->root_y), NULL), _g_free0 (ret), _tmp18_);
	_g_free0 (_tmp17_);
	ret = (_tmp20_ = g_strconcat (ret, _tmp19_ = g_strdup_printf ("\tRootWin    : %u\n", (guint) ((guint32) self->root_window)), NULL), _g_free0 (ret), _tmp20_);
	_g_free0 (_tmp19_);
	ret = (_tmp22_ = g_strconcat (ret, _tmp21_ = g_strdup_printf ("\tEventWin   : %u\n", (guint) ((guint32) self->event_window)), NULL), _g_free0 (ret), _tmp22_);
	_g_free0 (_tmp21_);
	ret = (_tmp24_ = g_strconcat (ret, _tmp23_ = g_strdup_printf ("\tChildWin   : %u\n", (guint) ((guint32) self->child_window)), NULL), _g_free0 (ret), _tmp24_);
	_g_free0 (_tmp23_);
	switch (self->type) {
		case UNITY_GESTURE_TYPE_PAN:
		{
			char* _tmp25_;
			char* _tmp26_;
			char* _tmp27_;
			char* _tmp28_;
			char* _tmp29_;
			char* _tmp30_;
			char* _tmp31_;
			char* _tmp32_;
			char* _tmp33_;
			char* _tmp34_;
			char* _tmp35_;
			char* _tmp36_;
			char* _tmp37_;
			char* _tmp38_;
			ret = (_tmp26_ = g_strconcat (ret, _tmp25_ = g_strdup_printf ("\tDeltaX     : %f\n", (double) self->pan_event->delta_x), NULL), _g_free0 (ret), _tmp26_);
			_g_free0 (_tmp25_);
			ret = (_tmp28_ = g_strconcat (ret, _tmp27_ = g_strdup_printf ("\tDeltaY     : %f\n", (double) self->pan_event->delta_y), NULL), _g_free0 (ret), _tmp28_);
			_g_free0 (_tmp27_);
			ret = (_tmp30_ = g_strconcat (ret, _tmp29_ = g_strdup_printf ("\tVelocityX  : %f\n", (double) self->pan_event->velocity_x), NULL), _g_free0 (ret), _tmp30_);
			_g_free0 (_tmp29_);
			ret = (_tmp32_ = g_strconcat (ret, _tmp31_ = g_strdup_printf ("\tVelocityY  : %f\n", (double) self->pan_event->velocity_y), NULL), _g_free0 (ret), _tmp32_);
			_g_free0 (_tmp31_);
			ret = (_tmp34_ = g_strconcat (ret, _tmp33_ = g_strdup_printf ("\tX          : %f\n", (double) self->pan_event->x), NULL), _g_free0 (ret), _tmp34_);
			_g_free0 (_tmp33_);
			ret = (_tmp36_ = g_strconcat (ret, _tmp35_ = g_strdup_printf ("\tY          : %f\n", (double) self->pan_event->y), NULL), _g_free0 (ret), _tmp36_);
			_g_free0 (_tmp35_);
			ret = (_tmp38_ = g_strconcat (ret, _tmp37_ = g_strdup_printf ("\tCurNFingers: %f\n", (double) self->pan_event->current_n_fingers), NULL), _g_free0 (ret), _tmp38_);
			_g_free0 (_tmp37_);
			break;
		}
		case UNITY_GESTURE_TYPE_PINCH:
		{
			char* _tmp39_;
			char* _tmp40_;
			char* _tmp41_;
			char* _tmp42_;
			char* _tmp43_;
			char* _tmp44_;
			char* _tmp45_;
			char* _tmp46_;
			char* _tmp47_;
			char* _tmp48_;
			char* _tmp49_;
			char* _tmp50_;
			char* _tmp51_;
			char* _tmp52_;
			ret = (_tmp40_ = g_strconcat (ret, _tmp39_ = g_strdup_printf ("\tRadiusDelta: %f\n", (double) self->pinch_event->radius_delta), NULL), _g_free0 (ret), _tmp40_);
			_g_free0 (_tmp39_);
			ret = (_tmp42_ = g_strconcat (ret, _tmp41_ = g_strdup_printf ("\tRadiusVeloc: %f\n", (double) self->pinch_event->radius_velocity), NULL), _g_free0 (ret), _tmp42_);
			_g_free0 (_tmp41_);
			ret = (_tmp44_ = g_strconcat (ret, _tmp43_ = g_strdup_printf ("\tRadius     : %f\n", (double) self->pinch_event->radius), NULL), _g_free0 (ret), _tmp44_);
			_g_free0 (_tmp43_);
			ret = (_tmp46_ = g_strconcat (ret, _tmp45_ = g_strdup_printf ("\tBoundingX1 : %f\n", (double) self->pinch_event->bounding_box_x1), NULL), _g_free0 (ret), _tmp46_);
			_g_free0 (_tmp45_);
			ret = (_tmp48_ = g_strconcat (ret, _tmp47_ = g_strdup_printf ("\tBoundingY1 : %f\n", (double) self->pinch_event->bounding_box_y1), NULL), _g_free0 (ret), _tmp48_);
			_g_free0 (_tmp47_);
			ret = (_tmp50_ = g_strconcat (ret, _tmp49_ = g_strdup_printf ("\tBoundingX2 : %f\n", (double) self->pinch_event->bounding_box_x2), NULL), _g_free0 (ret), _tmp50_);
			_g_free0 (_tmp49_);
			ret = (_tmp52_ = g_strconcat (ret, _tmp51_ = g_strdup_printf ("\tBoundingY2 : %f\n", (double) self->pinch_event->bounding_box_y2), NULL), _g_free0 (ret), _tmp52_);
			_g_free0 (_tmp51_);
			break;
		}
		case UNITY_GESTURE_TYPE_TAP:
		{
			char* _tmp53_;
			char* _tmp54_;
			char* _tmp55_;
			char* _tmp56_;
			char* _tmp57_;
			char* _tmp58_;
			ret = (_tmp54_ = g_strconcat (ret, _tmp53_ = g_strdup_printf ("\tDuration   : %f\n", (double) self->tap_event->duration), NULL), _g_free0 (ret), _tmp54_);
			_g_free0 (_tmp53_);
			ret = (_tmp56_ = g_strconcat (ret, _tmp55_ = g_strdup_printf ("\tX2         : %f\n", (double) self->tap_event->x2), NULL), _g_free0 (ret), _tmp56_);
			_g_free0 (_tmp55_);
			ret = (_tmp58_ = g_strconcat (ret, _tmp57_ = g_strdup_printf ("\tY2         : %f\n", (double) self->tap_event->y2), NULL), _g_free0 (ret), _tmp58_);
			_g_free0 (_tmp57_);
			break;
		}
		default:
		{
			break;
		}
	}
	result = ret;
	return result;
}


char* unity_gesture_event_type_to_string (UnityGestureType type) {
	char* result = NULL;
	if (type == UNITY_GESTURE_TYPE_PAN) {
		result = g_strdup ("Pan");
		return result;
	} else {
		if (type == UNITY_GESTURE_TYPE_PINCH) {
			result = g_strdup ("Pinch");
			return result;
		} else {
			if (type == UNITY_GESTURE_TYPE_ROTATE) {
				result = g_strdup ("Rotate");
				return result;
			} else {
				if (type == UNITY_GESTURE_TYPE_TAP) {
					result = g_strdup ("Tap");
					return result;
				} else {
					result = g_strdup ("Unknown");
					return result;
				}
			}
		}
	}
}


char* unity_gesture_event_state_to_string (UnityGestureState state) {
	char* result = NULL;
	if (state == UNITY_GESTURE_STATE_BEGAN) {
		result = g_strdup ("Began");
		return result;
	} else {
		if (state == UNITY_GESTURE_STATE_CONTINUED) {
			result = g_strdup ("Continued");
			return result;
		} else {
			if (state == UNITY_GESTURE_STATE_ENDED) {
				result = g_strdup ("Ended");
				return result;
			} else {
				result = g_strdup ("Unknown");
				return result;
			}
		}
	}
}


UnityGestureEvent* unity_gesture_event_construct (GType object_type) {
	UnityGestureEvent* self;
	self = (UnityGestureEvent*) g_type_create_instance (object_type);
	return self;
}


UnityGestureEvent* unity_gesture_event_new (void) {
	return unity_gesture_event_construct (UNITY_GESTURE_TYPE_EVENT);
}


static void unity_gesture_value_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_gesture_value_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_gesture_event_unref (value->data[0].v_pointer);
	}
}


static void unity_gesture_value_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_gesture_event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_gesture_value_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_gesture_value_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityGestureEvent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_gesture_event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_gesture_value_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityGestureEvent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_gesture_event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_gesture_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityGestureParamSpecEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_GESTURE_TYPE_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_gesture_value_get_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_EVENT), NULL);
	return value->data[0].v_pointer;
}


void unity_gesture_value_set_event (GValue* value, gpointer v_object) {
	UnityGestureEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_GESTURE_TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_gesture_event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_gesture_event_unref (old);
	}
}


void unity_gesture_value_take_event (GValue* value, gpointer v_object) {
	UnityGestureEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_GESTURE_TYPE_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_gesture_event_unref (old);
	}
}


static void unity_gesture_event_class_init (UnityGestureEventClass * klass) {
	unity_gesture_event_parent_class = g_type_class_peek_parent (klass);
	UNITY_GESTURE_EVENT_CLASS (klass)->finalize = unity_gesture_event_finalize;
}


static void unity_gesture_event_instance_init (UnityGestureEvent * self) {
	self->ref_count = 1;
}


static void unity_gesture_event_finalize (UnityGestureEvent* obj) {
	UnityGestureEvent * self;
	self = UNITY_GESTURE_EVENT (obj);
	_unity_gesture_pan_event_unref0 (self->pan_event);
	_unity_gesture_pinch_event_unref0 (self->pinch_event);
	_unity_gesture_tap_event_unref0 (self->tap_event);
}


GType unity_gesture_event_get_type (void) {
	static volatile gsize unity_gesture_event_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gesture_event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_gesture_value_event_init, unity_gesture_value_event_free_value, unity_gesture_value_event_copy_value, unity_gesture_value_event_peek_pointer, "p", unity_gesture_value_event_collect_value, "p", unity_gesture_value_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityGestureEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_gesture_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGestureEvent), 0, (GInstanceInitFunc) unity_gesture_event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_gesture_event_type_id;
		unity_gesture_event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityGestureEvent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_gesture_event_type_id__volatile, unity_gesture_event_type_id);
	}
	return unity_gesture_event_type_id__volatile;
}


gpointer unity_gesture_event_ref (gpointer instance) {
	UnityGestureEvent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_gesture_event_unref (gpointer instance) {
	UnityGestureEvent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_GESTURE_EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


UnityGesturePanEvent* unity_gesture_pan_event_construct (GType object_type) {
	UnityGesturePanEvent* self;
	self = (UnityGesturePanEvent*) g_type_create_instance (object_type);
	return self;
}


UnityGesturePanEvent* unity_gesture_pan_event_new (void) {
	return unity_gesture_pan_event_construct (UNITY_GESTURE_TYPE_PAN_EVENT);
}


static void unity_gesture_value_pan_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_gesture_value_pan_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_gesture_pan_event_unref (value->data[0].v_pointer);
	}
}


static void unity_gesture_value_pan_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_gesture_pan_event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_gesture_value_pan_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_gesture_value_pan_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityGesturePanEvent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_gesture_pan_event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_gesture_value_pan_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityGesturePanEvent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_gesture_pan_event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_gesture_param_spec_pan_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityGestureParamSpecPanEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_GESTURE_TYPE_PAN_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_gesture_value_get_pan_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_PAN_EVENT), NULL);
	return value->data[0].v_pointer;
}


void unity_gesture_value_set_pan_event (GValue* value, gpointer v_object) {
	UnityGesturePanEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_PAN_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_GESTURE_TYPE_PAN_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_gesture_pan_event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_gesture_pan_event_unref (old);
	}
}


void unity_gesture_value_take_pan_event (GValue* value, gpointer v_object) {
	UnityGesturePanEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_PAN_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_GESTURE_TYPE_PAN_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_gesture_pan_event_unref (old);
	}
}


static void unity_gesture_pan_event_class_init (UnityGesturePanEventClass * klass) {
	unity_gesture_pan_event_parent_class = g_type_class_peek_parent (klass);
	UNITY_GESTURE_PAN_EVENT_CLASS (klass)->finalize = unity_gesture_pan_event_finalize;
}


static void unity_gesture_pan_event_instance_init (UnityGesturePanEvent * self) {
	self->ref_count = 1;
}


static void unity_gesture_pan_event_finalize (UnityGesturePanEvent* obj) {
	UnityGesturePanEvent * self;
	self = UNITY_GESTURE_PAN_EVENT (obj);
}


GType unity_gesture_pan_event_get_type (void) {
	static volatile gsize unity_gesture_pan_event_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gesture_pan_event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_gesture_value_pan_event_init, unity_gesture_value_pan_event_free_value, unity_gesture_value_pan_event_copy_value, unity_gesture_value_pan_event_peek_pointer, "p", unity_gesture_value_pan_event_collect_value, "p", unity_gesture_value_pan_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityGesturePanEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_gesture_pan_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGesturePanEvent), 0, (GInstanceInitFunc) unity_gesture_pan_event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_gesture_pan_event_type_id;
		unity_gesture_pan_event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityGesturePanEvent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_gesture_pan_event_type_id__volatile, unity_gesture_pan_event_type_id);
	}
	return unity_gesture_pan_event_type_id__volatile;
}


gpointer unity_gesture_pan_event_ref (gpointer instance) {
	UnityGesturePanEvent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_gesture_pan_event_unref (gpointer instance) {
	UnityGesturePanEvent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_GESTURE_PAN_EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


UnityGesturePinchEvent* unity_gesture_pinch_event_construct (GType object_type) {
	UnityGesturePinchEvent* self;
	self = (UnityGesturePinchEvent*) g_type_create_instance (object_type);
	return self;
}


UnityGesturePinchEvent* unity_gesture_pinch_event_new (void) {
	return unity_gesture_pinch_event_construct (UNITY_GESTURE_TYPE_PINCH_EVENT);
}


static void unity_gesture_value_pinch_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_gesture_value_pinch_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_gesture_pinch_event_unref (value->data[0].v_pointer);
	}
}


static void unity_gesture_value_pinch_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_gesture_pinch_event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_gesture_value_pinch_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_gesture_value_pinch_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityGesturePinchEvent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_gesture_pinch_event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_gesture_value_pinch_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityGesturePinchEvent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_gesture_pinch_event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_gesture_param_spec_pinch_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityGestureParamSpecPinchEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_GESTURE_TYPE_PINCH_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_gesture_value_get_pinch_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_PINCH_EVENT), NULL);
	return value->data[0].v_pointer;
}


void unity_gesture_value_set_pinch_event (GValue* value, gpointer v_object) {
	UnityGesturePinchEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_PINCH_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_GESTURE_TYPE_PINCH_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_gesture_pinch_event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_gesture_pinch_event_unref (old);
	}
}


void unity_gesture_value_take_pinch_event (GValue* value, gpointer v_object) {
	UnityGesturePinchEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_PINCH_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_GESTURE_TYPE_PINCH_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_gesture_pinch_event_unref (old);
	}
}


static void unity_gesture_pinch_event_class_init (UnityGesturePinchEventClass * klass) {
	unity_gesture_pinch_event_parent_class = g_type_class_peek_parent (klass);
	UNITY_GESTURE_PINCH_EVENT_CLASS (klass)->finalize = unity_gesture_pinch_event_finalize;
}


static void unity_gesture_pinch_event_instance_init (UnityGesturePinchEvent * self) {
	self->ref_count = 1;
}


static void unity_gesture_pinch_event_finalize (UnityGesturePinchEvent* obj) {
	UnityGesturePinchEvent * self;
	self = UNITY_GESTURE_PINCH_EVENT (obj);
}


GType unity_gesture_pinch_event_get_type (void) {
	static volatile gsize unity_gesture_pinch_event_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gesture_pinch_event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_gesture_value_pinch_event_init, unity_gesture_value_pinch_event_free_value, unity_gesture_value_pinch_event_copy_value, unity_gesture_value_pinch_event_peek_pointer, "p", unity_gesture_value_pinch_event_collect_value, "p", unity_gesture_value_pinch_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityGesturePinchEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_gesture_pinch_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGesturePinchEvent), 0, (GInstanceInitFunc) unity_gesture_pinch_event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_gesture_pinch_event_type_id;
		unity_gesture_pinch_event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityGesturePinchEvent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_gesture_pinch_event_type_id__volatile, unity_gesture_pinch_event_type_id);
	}
	return unity_gesture_pinch_event_type_id__volatile;
}


gpointer unity_gesture_pinch_event_ref (gpointer instance) {
	UnityGesturePinchEvent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_gesture_pinch_event_unref (gpointer instance) {
	UnityGesturePinchEvent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_GESTURE_PINCH_EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


UnityGestureTapEvent* unity_gesture_tap_event_construct (GType object_type) {
	UnityGestureTapEvent* self;
	self = (UnityGestureTapEvent*) g_type_create_instance (object_type);
	return self;
}


UnityGestureTapEvent* unity_gesture_tap_event_new (void) {
	return unity_gesture_tap_event_construct (UNITY_GESTURE_TYPE_TAP_EVENT);
}


static void unity_gesture_value_tap_event_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void unity_gesture_value_tap_event_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		unity_gesture_tap_event_unref (value->data[0].v_pointer);
	}
}


static void unity_gesture_value_tap_event_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = unity_gesture_tap_event_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer unity_gesture_value_tap_event_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* unity_gesture_value_tap_event_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		UnityGestureTapEvent* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = unity_gesture_tap_event_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* unity_gesture_value_tap_event_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	UnityGestureTapEvent** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = unity_gesture_tap_event_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* unity_gesture_param_spec_tap_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	UnityGestureParamSpecTapEvent* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UNITY_GESTURE_TYPE_TAP_EVENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer unity_gesture_value_get_tap_event (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_TAP_EVENT), NULL);
	return value->data[0].v_pointer;
}


void unity_gesture_value_set_tap_event (GValue* value, gpointer v_object) {
	UnityGestureTapEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_TAP_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_GESTURE_TYPE_TAP_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		unity_gesture_tap_event_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_gesture_tap_event_unref (old);
	}
}


void unity_gesture_value_take_tap_event (GValue* value, gpointer v_object) {
	UnityGestureTapEvent* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UNITY_GESTURE_TYPE_TAP_EVENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UNITY_GESTURE_TYPE_TAP_EVENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		unity_gesture_tap_event_unref (old);
	}
}


static void unity_gesture_tap_event_class_init (UnityGestureTapEventClass * klass) {
	unity_gesture_tap_event_parent_class = g_type_class_peek_parent (klass);
	UNITY_GESTURE_TAP_EVENT_CLASS (klass)->finalize = unity_gesture_tap_event_finalize;
}


static void unity_gesture_tap_event_instance_init (UnityGestureTapEvent * self) {
	self->ref_count = 1;
}


static void unity_gesture_tap_event_finalize (UnityGestureTapEvent* obj) {
	UnityGestureTapEvent * self;
	self = UNITY_GESTURE_TAP_EVENT (obj);
}


GType unity_gesture_tap_event_get_type (void) {
	static volatile gsize unity_gesture_tap_event_type_id__volatile = 0;
	if (g_once_init_enter (&unity_gesture_tap_event_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { unity_gesture_value_tap_event_init, unity_gesture_value_tap_event_free_value, unity_gesture_value_tap_event_copy_value, unity_gesture_value_tap_event_peek_pointer, "p", unity_gesture_value_tap_event_collect_value, "p", unity_gesture_value_tap_event_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UnityGestureTapEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_gesture_tap_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityGestureTapEvent), 0, (GInstanceInitFunc) unity_gesture_tap_event_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType unity_gesture_tap_event_type_id;
		unity_gesture_tap_event_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UnityGestureTapEvent", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&unity_gesture_tap_event_type_id__volatile, unity_gesture_tap_event_type_id);
	}
	return unity_gesture_tap_event_type_id__volatile;
}


gpointer unity_gesture_tap_event_ref (gpointer instance) {
	UnityGestureTapEvent* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void unity_gesture_tap_event_unref (gpointer instance) {
	UnityGestureTapEvent* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UNITY_GESTURE_TAP_EVENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}




