/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <gmenu-tree.h>

typedef struct _UnityPackageSearcher UnityPackageSearcher;

typedef enum
{
  UNITY_PACKAGE_SEARCHTYPE_PREFIX,
  UNITY_PACKAGE_SEARCHTYPE_EXACT,
} UnityPackageSearchType;

typedef enum
{
  UNITY_PACKAGE_SORT_BY_NAME,
  UNITY_PACKAGE_SORT_BY_RELEVANCY,
} UnityPackageSort;

typedef struct
{
	GSList *results;
	gint    num_hits;
} UnityPackageSearchResult;

typedef struct
{
	gchar    *package_name;
	gchar    *application_name;
	gchar    *desktop_file;
	gchar    *icon;
	gint      relevancy;
} UnityPackageInfo;

#ifdef __cplusplus
extern "C" {
#endif
 
UnityPackageSearcher*     unity_package_searcher_new    ();

UnityPackageSearcher*     unity_package_searcher_new_for_menu    (GMenuTree *menu);

void                      unity_package_searcher_free   (UnityPackageSearcher *searcher);

UnityPackageSearchResult* unity_package_searcher_search (UnityPackageSearcher  *searcher,
                                                         const gchar           *search_string,
                                                         guint                  max_hits,
                                                         UnityPackageSearchType search_type,
                                                         UnityPackageSort       sort);

UnityPackageSearchResult* unity_package_searcher_get_random_apps (UnityPackageSearcher *searcher,
                                                                  const gchar          *filter_query,
                                                                  guint                 n_apps);

void                      unity_package_search_result_free (UnityPackageSearchResult *result);

#ifdef __cplusplus
}
#endif
 
