/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
/*
  *   The following code is used to simulate the reading/writing the data from TPM.
  *   Undefine MACRO SIMULATTE_TPM to compile the real TPM code
  */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "TPMCtrl/TPMInterface.h"
#include "TPMCtrl/TPMCtrl.h"
#include "GUI/debug.h"
#include "InfoMgmt/TCAgentIni.h"

#ifdef SIMULATTE_TPM

#define USER_DATA_TPM_FILE		"/etc/theftdeterrent/tpm_userdata.ini"
#define Provision_Packet_FILE	"/tmp/tpm_provision"
#define SHARE_DATA_FILE		"/tmp/tpm_share"

#define USER_DATA_SECT                 "userdata"

int TPM_CreateSpaceForTPM(char *ownerpwd)
{
	EXECUTE_POS
	return TSS_SUCCESS;
}


int TPM_SaveUserDataToTPM(BYTE *UserData)
{
	int boot_tick = 0;
	int boot_count = 0;
	char temp[30];
	
	TPMCtrl_Bootick( (TPMCtrl *)UserData, &boot_tick);
	sprintf(temp,"%d",boot_tick);
	Ini_WriteString(USER_DATA_SECT, "boot_tick",  temp, USER_DATA_TPM_FILE);
	
	TPMCtrl_BootCount( (TPMCtrl *)UserData, &boot_count);
	sprintf(temp,"%d",boot_count);
	Ini_WriteString(USER_DATA_SECT, "boot_count",  temp, USER_DATA_TPM_FILE);
	
	memcpy( temp, UserData + EXPIRYDATE_OFFSET, EXPIRYDATE_LENGTH);
	temp[EXPIRYDATE_LENGTH]=0;
	Ini_WriteString(USER_DATA_SECT, "expireDate", temp, USER_DATA_TPM_FILE);
	
	memcpy( temp, UserData + HWID_OFFSET, HWID_LENGTH);
	temp[HWID_LENGTH] = 0;
	Ini_WriteString(USER_DATA_SECT, "mac", temp, USER_DATA_TPM_FILE) ;
	
	EXECUTE_POS
	return TSS_SUCCESS;
}

int TPM_ReadUserDataFromTPM(BYTE* UserData)
{
	int boot_tick = 0;
	int boot_count = 0;
	char expireDate[24]={"071231"};
	char mac[25]={"aabbccddeeff"};
	BYTE * pbuf;
	FILE * fp = NULL;
	char temp[30];
	
	// Check if input parameter is availabe
	if(UserData == NULL)
	{
		return TPMCtrl_ExceptionStatus_ParamError;
	}

	while( 1 )
	{
		if (Ini_ReadString(USER_DATA_SECT, "boot_tick", "0", temp, USER_DATA_TPM_FILE) )
			break;
		boot_tick = atoi(temp);

		EXECUTE_POS

		
		if (Ini_ReadString(USER_DATA_SECT, "boot_count", "0", temp, USER_DATA_TPM_FILE) )
			break;
		boot_count = atoi(temp);

		if (Ini_ReadString(USER_DATA_SECT, "expireDate", "071231", expireDate, USER_DATA_TPM_FILE) )
			break;

		Ini_ReadString(USER_DATA_SECT, "mac", "aabbccddeeff", mac, USER_DATA_TPM_FILE) ;
			break;
	}

	
	memset( UserData, 0, USERDATA_LENGTH);
	
	pbuf = (BYTE* )(&boot_tick);
	*(UserData + BOOTTICK_OFFSET + 0) = *(pbuf + 2 );
	*(UserData + BOOTTICK_OFFSET + 1) = *(pbuf + 1 );
	*(UserData + BOOTTICK_OFFSET + 2) = *(pbuf + 0 );

	pbuf = (BYTE* )(&boot_count);
	*(UserData + BOOTCOUNT_OFFSET + 0) = *(pbuf + 2 );
	*(UserData + BOOTCOUNT_OFFSET + 1) = *(pbuf + 1 );
	*(UserData + BOOTCOUNT_OFFSET + 2) = *(pbuf + 0 );

	strncpy ( UserData + EXPIRYDATE_OFFSET,expireDate, 6);
	strncpy ( UserData + HWID_OFFSET, mac, 12);

	EXECUTE_POS
	return TSS_SUCCESS;
}


int ReadDataFromFile(char *file_name, BYTE *Packet)
{
	FILE * fp ;
	int offset = 0;
	fp = fopen( file_name, "rb");

	if ( !fp )
	{
		EXECUTE_POS
		printf ( "Open %s failed\n", file_name);
		return -1;
	}

	do
	{
		offset = fread( Packet + offset,  1, 512,  fp);
	}
	while( offset)  ;

	fclose(fp);
	
	return TSS_SUCCESS;
	
}

int WriteDataToFile( char *file_name,  BYTE *Packet, int PacketSize )
{
	FILE * fp ;
	int offset = 0;
	fp = fopen( file_name, "wb");

	if ( !fp )
	{
		EXECUTE_POS
		printf ( "Open %s failed\n", file_name);
		return -1;
	}

	offset = fwrite( Packet,  1,  PacketSize,  fp);

	fclose(fp);
	
	return TSS_SUCCESS;
	
}

int TPM_SaveProvisionPacketToTPM(BYTE *Packet,int PacketSize)
{
	EXECUTE_POS
	return WriteDataToFile(Provision_Packet_FILE, Packet, PacketSize);
}

int TPM_ReadProvisionPacketFromTPM(BYTE *Packet)
{
	EXECUTE_POS
	return ReadDataFromFile( Provision_Packet_FILE, Packet);
}

int TPM_SaveSharedSecretToTPM(BYTE *Secret)
{
	EXECUTE_POS
	return WriteDataToFile(SHARE_DATA_FILE, Secret, 1);
}

int TPM_ReadSharedSecretFromTPM(BYTE *Secret)
{
	EXECUTE_POS
	return ReadDataFromFile( SHARE_DATA_FILE, Secret);;
}








#endif
