/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_SCROLL_VIEW_H_
#define _NL_SCROLL_VIEW_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/clutk.h>

G_BEGIN_DECLS

#define NL_TYPE_SCROLL_VIEW (nl_scroll_view_get_type ())

#define NL_SCROLL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_SCROLL_VIEW, NlScrollView))

#define NL_SCROLL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_SCROLL_VIEW, NlScrollViewClass))

#define NL_IS_SCROLL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_SCROLL_VIEW))

#define NL_IS_SCROLL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_SCROLL_VIEW))

#define NL_SCROLL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_SCROLL_VIEW, NlScrollViewClass))

typedef struct _NlScrollView        NlScrollView;
typedef struct _NlScrollViewClass   NlScrollViewClass;
typedef struct _NlScrollViewPrivate NlScrollViewPrivate;
 
struct _NlScrollView
{
  CtkScrollView        parent;	

  NlScrollViewPrivate *priv;
};

struct _NlScrollViewClass
{
  CtkScrollViewClass   parent_class;
};

GType          nl_scroll_view_get_type   (void) G_GNUC_CONST;

ClutterActor * nl_scroll_view_new         (void);

G_END_DECLS

#endif /* _NL_SCROLL_VIEW_H_ */

