/* mozhelper: A GObject wrapper for the Mozilla Mozhelper API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MOZHELPER_PREFS_H__
#define __MOZHELPER_PREFS_H__

#include <glib-object.h>
#include <nsIPrefService.h>
#include <nsIPrefBranch2.h>

G_BEGIN_DECLS

#define MOZHELPER_TYPE_PREFS                                             \
  (mozhelper_prefs_get_type())
#define MOZHELPER_PREFS(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                 \
                               MOZHELPER_TYPE_PREFS,                     \
                               MozhelperPrefs))
#define MOZHELPER_PREFS_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                  \
                            MOZHELPER_TYPE_PREFS,                        \
                            MozhelperPrefsClass))
#define MOZHELPER_IS_PREFS(obj)                                          \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                 \
                               MOZHELPER_TYPE_PREFS))
#define MOZHELPER_IS_PREFS_CLASS(klass)                                  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                  \
                            MOZHELPER_TYPE_PREFS))
#define MOZHELPER_PREFS_GET_CLASS(obj)                                   \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                  \
                              MOZHELPER_TYPE_PREFS,                      \
                              MozhelperPrefsClass))

typedef struct _MozhelperPrefs         MozhelperPrefs;
typedef struct _MozhelperPrefsClass    MozhelperPrefsClass;
typedef struct _MozhelperPrefsPrivate  MozhelperPrefsPrivate;

struct _MozhelperPrefsClass
{
  GObjectClass parent_class;

  void (* read)           (MozhelperPrefs *prefs);
  void (* reset)          (MozhelperPrefs *prefs);
  void (* app_defaults)   (MozhelperPrefs *prefs);
  void (* branch_changed) (MozhelperPrefs    *prefs,
                           gint         id,
                           const gchar *domain);
};

struct _MozhelperPrefs
{
  GObject parent;

  MozhelperPrefsPrivate *priv;
};

GType mozhelper_prefs_get_type (void) G_GNUC_CONST;

MozhelperPrefs *mozhelper_prefs_new (void);

nsIPrefService *mozhelper_prefs_get_service     (MozhelperPrefs *prefs);

G_END_DECLS

#endif /* __MOZHELPER_PREFS_H__ */
