/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef _MWB_TAB_PICKER_H
#define _MWB_TAB_PICKER_H

#include <glib-object.h>
#include <clutter/clutter.h>
#include <nbtk/nbtk.h>
#include "mwb-tab.h"

G_BEGIN_DECLS

#define MWB_TYPE_TAB_PICKER mwb_tab_picker_get_type()

#define MWB_TAB_PICKER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MWB_TYPE_TAB_PICKER, MwbTabPicker))

#define MWB_TAB_PICKER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MWB_TYPE_TAB_PICKER, MwbTabPickerClass))

#define MWB_IS_TAB_PICKER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MWB_TYPE_TAB_PICKER))

#define MWB_IS_TAB_PICKER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MWB_TYPE_TAB_PICKER))

#define MWB_TAB_PICKER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MWB_TYPE_TAB_PICKER, MwbTabPickerClass))

typedef struct _MwbTabPickerPrivate MwbTabPickerPrivate;

typedef struct {
  NbtkWidget parent;

  MwbTabPickerPrivate *priv;
} MwbTabPicker;

typedef struct {
  NbtkWidgetClass parent_class;

  void (* tab_activated)   (MwbTabPicker *picker, MwbTab *tab);
  void (* chooser_clicked) (MwbTabPicker *picker);
} MwbTabPickerClass;

GType mwb_tab_picker_get_type (void);

NbtkWidget* mwb_tab_picker_new (void);

void mwb_tab_picker_add_tab (MwbTabPicker *picker, MwbTab *tab, gint position);

void mwb_tab_picker_remove_tab (MwbTabPicker *picker, MwbTab *tab);

GList *mwb_tab_picker_get_tabs (MwbTabPicker *picker);

gint mwb_tab_picker_get_n_tabs (MwbTabPicker *picker);

MwbTab *mwb_tab_picker_get_tab (MwbTabPicker *picker, gint tab);

gint mwb_tab_picker_get_tab_no (MwbTabPicker *picker, MwbTab *tab);

gint mwb_tab_picker_get_current_tab (MwbTabPicker *picker);

void mwb_tab_picker_set_current_tab (MwbTabPicker *picker, gint tab);

void mwb_tab_picker_reorder (MwbTabPicker *picker,
                             gint          old_position,
                             gint          new_position);

void mwb_tab_picker_set_tab_width (MwbTabPicker *picker,
                                   gint          width);

gint mwb_tab_picker_get_tab_width (MwbTabPicker *picker);

void
mwb_tab_picker_get_preferred_height (MwbTabPicker *tab_picker,
                                     gfloat        for_width,
                                     gfloat       *min_height_p,
                                     gfloat       *natural_height_p,
                                     gboolean      with_previews);

void mwb_tab_picker_set_preview_mode (MwbTabPicker *picker, gboolean preview);

gboolean mwb_tab_picker_get_preview_mode (MwbTabPicker *picker);

G_END_DECLS

#endif /* _MWB_TAB_PICKER_H */

