/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <nsIGenericFactory.h>
#include <nsIModule.h>
#include "mwb-settings.h"
#include "mwb-start-page.h"
#include "mwb-favicon-loader.h"
#include "mwb-gettext.h"

NS_GENERIC_FACTORY_SINGLETON_CONSTRUCTOR (MwbSettings,
                                          MwbSettings::GetSingleton)
NS_GENERIC_FACTORY_SINGLETON_CONSTRUCTOR (MwbStartPage,
                                          MwbStartPage::GetSingleton)
NS_GENERIC_FACTORY_SINGLETON_CONSTRUCTOR (MwbFaviconLoader,
                                          MwbFaviconLoader::GetSingleton)
NS_GENERIC_FACTORY_SINGLETON_CONSTRUCTOR (MwbGettext,
                                          MwbGettext::GetSingleton)

static const nsModuleComponentInfo
components[] =
{
  {
    "MWB Settings",
    MWB_SETTINGS_CID,
    "@moblin.org/mwb-settings-service;1",
    MwbSettingsConstructor,
  },

  {
    "MWB Start Page",
    MWB_START_PAGE_CID,
    "@moblin.org/mwb-start-page-service;1",
    MwbStartPageConstructor,
  },

  {
    "MWB Favicon Loader",
    MWB_FAVICON_LOADER_CID,
    NS_NETWORK_PROTOCOL_CONTRACTID_PREFIX "mwb-favicon",
    MwbFaviconLoaderConstructor
  },

  {
    "MWB Gettext",
    MWB_GETTEXT_CID,
    "@moblin.org/mwb-gettext-service;1",
    MwbGettextConstructor
  }
};

NS_IMPL_NSGETMODULE (MwbPagesModule, components)
