/*
 * Moblin-Web-Browser: The web browser for Moblin
 * Copyright (c) 2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

/* This overrides the default nsILoginManagerPrompter so that it
 * always stores the passwords without prompting */

function MwbLoginManagerPrompter()
{
}

MwbLoginManagerPrompter.prototype =
{
  classDescription : "MwbLoginManagerPrompter",
  contractID : "@mozilla.org/login-manager/prompter;1",
  classID : Components.ID("63fc722c-5e55-4f18-b447-0e52e8f062de}"),
  QueryInterface : XPCOMUtils.generateQI([Components.interfaces.
                                          nsILoginManagerPrompter]),

  _loginManager : null,

  _getLoginManager : function()
  {
    if (this._loginManager == null)
      this._loginManager = (Components.classes["@mozilla.org/login-manager;1"].
                            getService(Components.interfaces.nsILoginManager));
    return this._loginManager;
  },

  init : function (aWindow)
  {
    /* Don't need to do anything */
  },

  promptToSavePassword : function (aLogin)
  {
    /* Always remember the login without prompting */
    this._getLoginManager().addLogin(aLogin);
  },


  promptToChangePassword : function (aOldLogin, aNewLogin)
  {
    /* Always modify the login */
    this._getLoginManager().modifyLogin(aOldLogin, aNewLogin);
  },

  promptToChangePasswordWithUsernames : function (logins, count, aNewLogin)
  {
    /* We would need to prompt the user here to select a username so
     * instead it just does nothing */
  }
};

var component = [MwbLoginManagerPrompter];

function NSGetModule(compMgr, fileSpec)
{
  return XPCOMUtils.generateModule(component);
}
