/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Florian Boucault <florian.boucault@canonical.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "test.h"
#include "deelistmodel.h"

int main(int argc, char *argv[])
{
    TestApplication application(argc, argv);

    DeeListModel* model = new DeeListModel;

    QObject::connect(model, SIGNAL(readyChanged(bool)), &application, SLOT(onReadyChanged(bool)));
    QObject::connect(model, SIGNAL(rowsInserted(QModelIndex, int, int)), &application, SLOT(onRowsInserted()));

    model->setName("com.canonical.Unity.ApplicationsPlace.ResultsModel");

    return application.exec();
}
