/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */


#ifndef _GGADGET_SOURCE_H_
#define _GGADGET_SOURCE_H_

#include <glib.h>
#include <glib-object.h>
#include <libgadget/libgadget.h>

G_BEGIN_DECLS

#define GGADGET_TYPE_SOURCE (ggadget_source_get_type ())

#define GGADGET_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        GGADGET_TYPE_SOURCE, GGadgetSource))

#define GGADGET_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
      	GGADGET_TYPE_SOURCE, GGadgetSourceClass))

#define GGADGET_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        GGADGET_TYPE_SOURCE))

#define GGADGET_SOURCE_IS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        GGADGET_TYPE_SOURCE))

#define GGADGET_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
        GGADGET_TYPE_SOURCE, GGadgetSourceClass))

typedef struct _GGadgetSource        GGadgetSource;
typedef struct _GGadgetSourceClass   GGadgetSourceClass;
typedef struct _GGadgetSourcePrivate GGadgetSourcePrivate;

struct _GGadgetSource
{
  GadgetSource parent;

  GGadgetSourcePrivate *priv;
};

struct _GGadgetSourceClass
{
  /*< private >*/
  GadgetSourceClass  parent_class;

  /*< public >*/
  
  /* signals, not vfuncs */
  
  /* vtable */
  
  /*< private >*/
  /* padding */
  void (*_ggadget_source_padding1) (void);
  void (*_ggadget_source_padding2) (void);
  void (*_ggadget_source_padding3) (void);
  void (*_ggadget_source_padding4) (void);
  void (*_ggadget_source_padding5) (void);
  void (*_ggadget_source_padding6) (void);
};

GType ggadget_source_get_type (void) G_GNUC_CONST;

GadgetSource * ggadget_source_get_default (void);

G_END_DECLS

#endif /* _GGADGET_SOURCE_H_ */

