/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#ifndef DBG_PRINT_H
#define DBG_PRINT_H

#include <stdio.h>

#ifdef _DEBUG

extern FILE *fil_fnkey;
#define DbgOpen() \
{ fil_fnkey = fopen("/var/tmp/FnKey.log", "w+"); }

#define DbgPrint(format, arg...) \
{ fprintf(fil_fnkey, "%s " format, __func__, ##arg); fflush(fil_fnkey); }
#else
#define DbgOpen()
#define DbgPrint(format, arg...)
#endif

#endif /* DBG_PRINT_H */

