/*
 * Enhanced Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#include <iostream>
#include <fstream>
#include <net/if.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>
#include <linux/types.h>
#include <linux/wireless.h>
#include <linux/ethtool.h>
#include <linux/sockios.h>
#include <errno.h>
#include <vector.h>
#include <wx/utils.h>
#include <wx/file.h>
#include "ENMUtil.h"
#include "LinuxNetworkAPI.h"
#include <pthread.h>
#include <wx/textfile.h>
const int MAX_HOST_NAME_LEN = 200;
using namespace std;
extern FILE* enm_log;

void* ExecOrderThread(void* parameter)
{
    char cFirOrder[ORDERBUFSIZE];
    strncpy(cFirOrder, (const char*)parameter, ORDERBUFSIZE);

    system(cFirOrder);

    return (NULL);
}

LinuxNetworkAPI::LinuxNetworkAPI()
{
    m_pSearchThread = NULL;
    linuxAPI = NULL;
    linuxAPI = fopen("/tmp/LinuxNetworkAPI.txt", "w");
}

LinuxNetworkAPI::~LinuxNetworkAPI()
{

}

bool LinuxNetworkAPI::IfConnect(const string adapterName)
{
    struct sockaddr_in *addr;
    struct ifreq ifr;
    char* address;
    int sockfd;
    if (adapterName.empty())
    {
       return false;
    }
    sockfd = socket(PF_INET,SOCK_DGRAM,0);
   strncpy(ifr.ifr_name,adapterName.c_str(),IFNAMSIZ);

    if(ioctl(sockfd,SIOCGIFADDR,&ifr) == -1)
    {
        perror("ioctl error");
        close(sockfd);
        return false;
    }
    else
    {
        close(sockfd);
        addr = (struct sockaddr_in *)&(ifr.ifr_addr);
        address = inet_ntoa(addr->sin_addr);
        if (address == NULL)
        {
            return false;
        }
        else
        {
            if (!strcmp(address, "127.0.0.1"))
            {
                return false;
            }
            else
            {
                return true;
            }
        }
    }
}

string LinuxNetworkAPI::GetIPAddressHLAN(const string adapterName, const string userPath)
{
//    wxString IP;
//    if ( !adapterName.empty() )
//    {
//        char cOrder[ORDERBUFSIZE];
//        sprintf(cOrder, "ifconfig %s > /tmp/ifcForIP.txt", adapterName.c_str());
//        system(cOrder);
//        ifstream in;
//        string sPath = "/tmp/ifcForIP.txt";
//        const char* cFileName = sPath.c_str();
//        in.open(cFileName,ios_base::in);
//        char cFileBuf[1024];
//        while(in.getline(cFileBuf, sizeof(cFileBuf)))
//        {
//            wxString content = wxString::FromUTF8(cFileBuf);
//            if ((int) content.find(wxT("inet addr:")) > 0)
//            {
//                size_t posBegin = content.Find(wxT("inet addr:")) + 10;
//                size_t posEnd = content.Find(wxT("Bcast:")) - 2;
//                int len = posEnd - posBegin;
//                IP = content.Mid(posBegin, len);
//                break;
//            }
//        }
//        in.close();
//    }
//
//    return ENMUtil::WxStringToString(IP);

    return GetIP(adapterName);

}

string LinuxNetworkAPI::GetConnectTypeHLAN(const string adapterName, const string userPath)
{
    char cOrder[ORDERBUFSIZE];
    sprintf(cOrder, "ethtool %s > /tmp/eth.txt", adapterName.c_str());
    system(cOrder);
    ifstream in;
    string sPath = "/tmp/eth.txt";
    const char* cFileName = sPath.c_str();
    in.open(cFileName,ios_base::in);
    char cFileBuf[1024];
    wxString speed;
    string s;
    while(in.getline(cFileBuf, sizeof(cFileBuf)))
    {
        wxString content = wxString::FromUTF8(cFileBuf);
        if ((int) content.find(wxT("Speed:")) > 0)
        {
            size_t posBegin = content.Find(wxT("Speed:")) + 7;
            speed = content.Mid(posBegin);
            s = "Wired LAN - " + ENMUtil::WxStringToString(speed);
            break;
        }
    }
    in.close();

    return s;
}

int LinuxNetworkAPI::OpenSockets()
{
	static const int families[] = {
		AF_INET, AF_IPX, AF_AX25, AF_APPLETALK
	};
	unsigned int i;
	int	sock;

	for(i = 0; i < sizeof(families)/sizeof(int); ++i)
	{
		sock = socket(families[i], SOCK_DGRAM, 0);
		if(sock >= 0)
        return sock;
	}

	return -1;
}

void LinuxNetworkAPI::CloseSockets(const int socketID)
{
    close(socketID);
}

void LinuxNetworkAPI::GetNetInfo(const string path,wxArrayString& wiredInterfaceList,wxArrayString& wirelessInterfaceList)
{
    wiredInterfaceList.Clear();
    wirelessInterfaceList.Clear();
    system("iwconfig > /tmp/iwc.txt");
    system("ifconfig -a -s > /tmp/ifc.txt");
    ifstream iwcstream;
    ifstream ifcstream;
	string sIwcPath = "/tmp/iwc.txt";
	string sIfcPath = "/tmp/ifc.txt";
    iwcstream.open(sIwcPath.c_str(),ios_base::in);
    ifcstream.open(sIfcPath.c_str(),ios_base::in);
    char cIwcFileBuf[1024];
    char cIfcFileBuf[1024];
    char wirelessAdapterName[128] = {0};
    char ifcName[128] = {0};
    int linecount = 1;
    while(ifcstream.getline(cIfcFileBuf, sizeof(cIfcFileBuf)))
    {
        memset(ifcName, '\0', 128);
        if (1 != linecount)
        {
            int i = 0;
            while (cIfcFileBuf[i] != ' ' &&  cIfcFileBuf[i] != '\t' &&  cIfcFileBuf[i] != '\n' &&  cIfcFileBuf[i] != '\0')
            {
                ifcName[i] = cIfcFileBuf[i];
                i++;
            }
            string sName(ifcName);
            if ( sName != "lo" && sName != "wmaster0" && string::npos == sName.find(":avahi") && sName != "mesh0")
            {
                wiredInterfaceList.Add(wxString::FromUTF8((const char*)ifcName));
            }
        }
        linecount++;
    }
    while(iwcstream.getline(cIwcFileBuf, sizeof(cIwcFileBuf)))
    {
        if (cIwcFileBuf[0] != ' ' && cIwcFileBuf[0] != ' ' &&  cIwcFileBuf[0] != '\t' &&  cIwcFileBuf[0] != '\n' &&  cIwcFileBuf[0] != '\0')
        {
            int i = 0;
            while (cIwcFileBuf[i] != ' ' &&  cIwcFileBuf[i] != '\t' &&  cIwcFileBuf[i] != '\n' &&  cIwcFileBuf[i] != '\0')
            {
                wirelessAdapterName[i] = cIwcFileBuf[i];
                i++;
            }
            string wirelessName(wirelessAdapterName);
            if ( wirelessName != "mesh0" )
            {
                wirelessInterfaceList.Add(wxString::FromUTF8((const char*)wirelessAdapterName));
            }
        }
    }
    for (int j = 0; j < wirelessInterfaceList.Count(); j++)
    {
        for (int k = 0; k < wiredInterfaceList.Count(); k++)
        {
            if ( wiredInterfaceList[k].Cmp(wirelessInterfaceList[j]) == 0 )
            {
                wiredInterfaceList.RemoveAt(k);
            }
        }
    }
//    for (int i = 0; i < wiredInterfaceList.Count(); i++)
//    {
//        char name[wiredInterfaceList[i].Len()];
//        strcpy(name,wiredInterfaceList[i].mb_str());
//        printf("%d wired interface: %s\n", i + 1, name);
//    }
//    for (int i = 0; i < wirelessInterfaceList.Count(); i++)
//    {
//        char name[wirelessInterfaceList[i].Len()];
//        strcpy(name,wirelessInterfaceList[i].mb_str());
//        printf("%d wireless interface: %s\n", i + 1, name);
//    }
//    printf("------------------------------------------\n");
    iwcstream.close();
    ifcstream.close();
}

bool LinuxNetworkAPI::ShutdownInterface(const wxArrayString& interfaceList)
{
    bool flag = true;

    for (int i = 0; i < interfaceList.Count(); i++)
    {
//        for ( int j = 0; j < 5; j++ )
//        {
            char cOrder[ORDERBUFSIZE];
            sprintf(cOrder, "ifconfig %s down", ENMUtil::WxStringToString(interfaceList[i]).c_str());
            fprintf(linuxAPI, "exec %s\n", cOrder);
            system(cOrder);
            fflush(linuxAPI);
//        }
        fflush(linuxAPI);
    }
    return flag;
}

string LinuxNetworkAPI::StartupInterface(const wxArrayString& interfaceList, const string path)
{
    string name = "";
    fprintf(linuxAPI, "StartupInterface\n");
    int i = 0;
    for (i = 0; i < interfaceList.Count(); i++)
    {
//        if ( interfaceList[i].Cmp(_T("ra0")) )
//        {
            char cOrder[ORDERBUFSIZE];
            sprintf(cOrder, "ifconfig %s up", ENMUtil::WxStringToString(interfaceList[i]).c_str());
            fprintf(linuxAPI, "ifconfig %s up",ENMUtil::WxStringToString(interfaceList[i]).c_str());
            system(cOrder);
            fprintf(linuxAPI, "ifconfig up finish\n");
            name = ENMUtil::WxStringToString(interfaceList[i]);
            fprintf(linuxAPI, "name is %s\n", name.c_str());
            fflush(linuxAPI);
            string uselessPara = "uselessPara";
            if ( IfUp(interfaceList, uselessPara) )
            {
                break;
            }
            else
            {
                name = "";
            }
//        }
    }
    if ( "" == name )
    {
//        fprintf(linuxAPI, "current adapter is null\n");
    }
    else
    {
//        fprintf(linuxAPI, "current adapter %s\n", name.c_str());
    }
    fflush(linuxAPI);
    return name;
}

bool LinuxNetworkAPI::DispatchDisableEvent(const wxArrayString& interfaceList)
{
    for (int i = 0; i < interfaceList.Count(); i++)
    {
//        for ( int j = 0; j < 5; j++ )
//        {
            char cOrder[ORDERBUFSIZE];
            sprintf(cOrder, "ifconfig %s down", ENMUtil::WxStringToString(interfaceList[i]).c_str());
            system(cOrder);
//        }
        fprintf(linuxAPI, "in DispatchDisableEvent %s\n", cOrder);
        fflush(linuxAPI);
    }
    string para = "uselessPara";
    bool ifSuccess = IfUp(interfaceList, para);

    return ifSuccess;
}

bool LinuxNetworkAPI::CloseWlanConnection(const string adpterName)
{
    char cFirOrder[128];
    sprintf(cFirOrder, "dhclient %s -r", adpterName.c_str());
    system(cFirOrder);
    sprintf(cFirOrder, "iwconfig %s essid \\\"\\\"", adpterName.c_str());
    system(cFirOrder);
    system("killall wpa_supplicant");
    sprintf(cFirOrder, "ifconfig %s up", adpterName.c_str());
    system(cFirOrder);
//    sprintf(cFirOrder, "iwconfig %s essid any", adpterName.c_str());
//    system(cFirOrder);
//    sprintf(cFirOrder, "iwlist %s scanning", adpterName.c_str());
//    system(cFirOrder);
    return true;
}

string  LinuxNetworkAPI::GetSsid(const string userPath)
{
    system("iwconfig > /tmp/iwconfig.txt");
    ifstream in;
    string sPath = "/tmp/iwconfig.txt";
    const char* cFileName = sPath.c_str();
    in.open(cFileName,ios_base::in);
    char cFileBuf[1024];
    wxString essid;
    while(in.getline(cFileBuf, sizeof(cFileBuf)))
    {
        wxString content = wxString::FromUTF8(cFileBuf);
        size_t posBegin = content.Find(wxT("\"")) + 1;
        if ((int) content.find(wxT("ESSID:")) > 0 && (int) content.find(wxT("ra0")) == 0)
        {
            essid = content.Mid(posBegin);
            essid = essid.Mid(0, essid.Find(wxT("\"")));
            break;
        }
    }

    in.close();

    return ENMUtil::WxStringToString(essid);
}

bool LinuxNetworkAPI::ScanNetwork(const string adapterName , const string userPath, AccessPointList& accessPointList)
{
    char cOrder[ORDERBUFSIZE];
//    sprintf(cOrder, "iwlist %s scan > /tmp/scanresult.txt", adapterName.c_str());
    sprintf(cOrder, "iwlist %s scan > /tmp/scanresult.txt", "ra0");
    system("killall nm-applet");
    system(cOrder);
    ifstream in;
    string sPath = "/tmp/scanresult.txt";
    const char* cFileName = sPath.c_str();
    in.open(cFileName,ios_base::in);
    char cFileBuf[FILESIZE];
    APStatus ap;
    memset(&ap, '\0', sizeof(APStatus));
    vector<APStatus> APVec;
    wxString MAC;
    wxString Essid;
    wxString Protocol;
    wxString tempChannel;
    int channel;
    wxString key;
    wxString tempQual;
    int qual;
    wxString auth;
    int cellCount = 0;
    bool isWPA = false;
    wxString authType;
    wxString encryptType;
    while(in.getline(cFileBuf, sizeof(cFileBuf)))
    {
        wxString content = wxString::FromUTF8(cFileBuf);
        if ((int) content.find(wxT("Cell")) > 0)
        {
            if ( cellCount > 0 )
            {
                if (wcscmp(ap.name, wxT("notshow")))
                {
                    if ( APVec.size() < 32 )
                    {
                        if ( isWPA )
                        {
                            if ( authType == _T("WPA") )
                            {
                                if ( encryptType == _T("TKIP") )
                                {
                                    ap.auth = WLAN_AUTH_WPAPSK_TKIP;
                                }
                                if ( encryptType == _T("CCMP") )
                                {
                                    ap.auth = WLAN_AUTH_WPAPSK_AES;
                                }
                            }
                            if ( authType == _T("WPA2") )
                            {
                                if ( encryptType == _T("TKIP") )
                                {
                                    ap.auth = WLAN_AUTH_WPA2PSK_TKIP;
                                }
                                if ( encryptType == _T("CCMP") )
                                {
                                    fprintf(linuxAPI, "WPA2 CCMP\n");
                                    fflush(linuxAPI);
                                    ap.auth = WLAN_AUTH_WPA2PSK_AES;
                                }
                            }
                            isWPA = false;
                        }
                        APVec.push_back(ap);
                    }
                }
            }
            MAC = content.Mid(content.find(wxT(":")) + 2, 18);
            const wxWX2MBbuf tmp_buf = wxConvCurrent->cWX2MB(MAC);
            const char* tmp_str = (const char*) tmp_buf;
            StringToMacAddress((unsigned char*)ap.macAddress, tmp_str, 17);
            //fprintf(linuxAPI, "ap.macAddress is %s\n", ap.macAddress);
            cellCount++;

        }
        else if ((int) content.find(wxT("ESSID:")) > 0)
        {
            Essid = content.Mid(content.find(wxT("ESSID:")) + 7, content.Len() - content.find(wxT(":")) - 3);
            wmemset(ap.name, 0, AP_SSID_MAX_LENGTH);
            if (Essid.IsEmpty())
            {
                const char* tmp_str = "<Hidden>";
                mbstowcs(ap.name, tmp_str, strlen(tmp_str));
                ap.ssid.length = 0;
                memset(ap.ssid.ucSsid, '\0', AP_SSID_MAX_LENGTH);
                strncpy((char*)ap.ssid.ucSsid, "<Hidden>", AP_SSID_MAX_LENGTH);
//                wcout << ap.name << endl;
            }
            else
            {
                string sName = ENMUtil::WxStringToString(Essid);
                mbstowcs(ap.name, sName.c_str(), sName.length());
                ap.ssid.length = (ENMUtil::WxStringToString(Essid)).length();
                memset(ap.ssid.ucSsid, '\0', AP_SSID_MAX_LENGTH);
                strncpy((char*)ap.ssid.ucSsid, ENMUtil::WxStringToString(Essid).c_str(), AP_SSID_MAX_LENGTH);
            }
//            printf("ssid is %s\n", ap.ssid.ucSsid);
//fwprintf(linuxAPI, L"ap.name is %s\n", ap.name);
//fprintf(linuxAPI, "ap.ssid.length is %d\n", ap.ssid.length);
//fprintf(linuxAPI, "ssid is %s\n", ap.ssid.ucSsid);
        }
        else if ((int) content.find(wxT("Protocol:")) > 0)
        {
            Protocol = content.Mid(content.find(wxT("Protocol:")) + 9);
            if (Protocol.Contains(wxT("n")))
            {
                ap.type = WLAN_802_11_N;
            }
            else if (Protocol.Contains(wxT("g")))
            {
                ap.type = WLAN_802_11_G;
            }
            else if (Protocol.Contains(wxT("b")))
            {
                ap.type = WLAN_802_11_B;
            }
            else
            {
                ap.type = WLAN_UNKNOWN;
            }
//            printf("type %d\n", ap.type);
//fprintf(linuxAPI, "type %d\n", ap.type);
        }
        else if ((int) content.find(wxT("Channel")) > 0)
        {
            tempChannel = content.Mid(content.find(wxT("Channel")) + 8, (content.find(wxT(")")) - content.find(wxT("Channel ")) - 8));
            channel = atoi(tempChannel.fn_str());
            ap.channel = channel;
//            printf("channel %d\n", ap.channel);
//fprintf(linuxAPI, "ap.channel %d\n", ap.channel);
        }
        else if ((int) content.find(wxT("Encryption key:")) > 0)
        {
            ap.auth = WLAN_AUTH_OPEN_WEP;
            key = content.Mid(content.find(wxT("Encryption key:")) + 15);
            if (key.Contains(wxT("off")))
            {
                ap.auth = WLAN_AUTH_OPEN_NONE;
            }
            else if ( key.Contains(wxT("on")) )
            {
                ap.auth = WLAN_AUTH_OPEN_WEP;
            }
        }
        else if ((int) content.find(wxT("Quality")) > 0)
        {
            tempQual = content.Mid(content.find(wxT("Quality")) + 8, (content.find(wxT("/")) - content.find(wxT("Quality=")) - 8));
            qual = atoi(tempQual.fn_str());
            ap.signalQuality = qual;
//            printf("signalQuality %d\n", ap.signalQuality);
//fprintf(linuxAPI, "ap.signalQuality %d\n", ap.signalQuality);
        }
        else if ((int) content.find(wxT("IE: ")) > 0)
        {
                isWPA = true;
            auth = content.Mid(content.find(wxT("IE: ")) + 4);
                fprintf(linuxAPI, "auth %s\n", ENMUtil::WxStringToString(auth).c_str());
                fflush(linuxAPI);
            if (auth.Contains(wxT("WPA")))
            {
                authType = _T("WPA");
                fprintf(linuxAPI, "authType %s\n", ENMUtil::WxStringToString(authType).c_str());
                fflush(linuxAPI);
//                ap.auth = WLAN_AUTH_WPAPSK_TKIP;
            }
            if (auth.Contains(wxT("WPA2")))
            {
                //fprintf(linuxAPI, "type %d\n", ap.type);
                authType = _T("WPA2");
                fprintf(linuxAPI, "authType %s\n", ENMUtil::WxStringToString(authType).c_str());
                fflush(linuxAPI);
//                ap.auth = WLAN_AUTH_WPAPSK_TKIP;
            }
//                IfEncrypt = false;
//            }
//            printf("auth %d\n", ap.auth);
//fprintf(linuxAPI, "ap.auth %d\n", ap.auth);
        }
        else if ( (int) content.find(wxT("Group Cipher")) > 0 )
        {
                fprintf(linuxAPI, "content %s\n", ENMUtil::WxStringToString(content).c_str());
                fflush(linuxAPI);
            if ( content.Contains(wxT("TKIP")) )
            {
                encryptType = _T("TKIP");
                fprintf(linuxAPI, "encryptType %s\n", ENMUtil::WxStringToString(encryptType).c_str());
                fflush(linuxAPI);
            }
            if ( content.Contains(wxT("CCMP")) )
            {
                encryptType = _T("CCMP");
                fprintf(linuxAPI, "encryptType %s\n", ENMUtil::WxStringToString(encryptType).c_str());
                fflush(linuxAPI);
            }
        }
//        else if ((int) content.find(wxT("Extra:")) > 0)
//        {
//            if (wcscmp(ap.name, wxT("notshow")))
//            {
//                APVec.push_back(ap);
//            }
//        }
        else
        {
//            APVec.push_back(ap);
        }
    }
    if (wcscmp(ap.name, wxT("notshow")))
    {
        if ( APVec.size() < 32 )
        {
            if ( isWPA )
            {
                if ( authType == _T("WPA") )
                {
                    if ( encryptType == _T("TKIP") )
                    {
                        ap.auth = WLAN_AUTH_WPAPSK_TKIP;
                    }
                    if ( encryptType == _T("CCMP") )
                    {
                        ap.auth = WLAN_AUTH_WPAPSK_AES;
                    }
                }
                if ( authType == _T("WPA2") )
                {
                    if ( encryptType == _T("TKIP") )
                    {
                        ap.auth = WLAN_AUTH_WPA2PSK_TKIP;
                    }
                    if ( encryptType == _T("CCMP") )
                    {
                        fprintf(linuxAPI, "WPA2 CCMP\n");
                        fflush(linuxAPI);
                        ap.auth = WLAN_AUTH_WPA2PSK_AES;
                    }
                }
                isWPA = false;
            }
        APVec.push_back(ap);
        }
    }
    if (!APVec.empty())
    {
        //accessPointList.apList = new APStatus[APVec.size()];
        int k = 0;
        for (vector<APStatus>::iterator it = APVec.begin(); it != APVec.end(); ++it)
        {
            accessPointList.apList[k] = *it;
            k++;
        }
        accessPointList.nCount = k;
//        printf("%d\n", accessPointList.nCount);
    }
    in.close();
fflush(linuxAPI);
    return true;
}

bool LinuxNetworkAPI::ConnectAP(const string adapterName, const string key, const string ssid, const int auth)
{
    CloseWlanConnection(adapterName);
//    fprintf(linuxAPI, "adapterName----> %s\n", adapterName.c_str());
//    fprintf(linuxAPI, "key----> %s\n", key.c_str());
//    fprintf(linuxAPI, "ssid----> %s\n", ssid.c_str());
//    fprintf(linuxAPI, "auth----> %d\n", auth);
//    fflush(linuxAPI);
    char cFirOrder[ORDERBUFSIZE];
    const char * name = adapterName.c_str();

//    sprintf(cFirOrder, "iwconfig %s essid \"\"", name);
//    system(cFirOrder);
    fprintf(linuxAPI, "ConnectAP --> %d\n", auth);
    fprintf(linuxAPI, "ConnectAP --> %d\n", auth & 0X00FFFF);
    fflush(linuxAPI);
    switch( auth & 0X00FFFF )
    {
        case WLAN_AUTH_WPAPSK_TKIP:
        {
            fprintf(linuxAPI, "WLAN_AUTH_WPAPSK_TKIP\n");
            fflush(linuxAPI);
            const char* cKey = key.c_str();
            sprintf(cFirOrder, "wpa_passphrase %s %s > /etc/wpa_supplicant/WIFI.conf", ssid.c_str(), cKey);
//            fprintf(linuxAPI, "wpa_supplicant----> %s\n", cFirOrder);
//            fflush(linuxAPI);
            system(cFirOrder);

            wxTextFile tf(_T("/etc/wpa_supplicant/WIFI.conf"));
            tf.Open();
            tf.InsertLine(_T("ap_scan=2"),0);
            tf.InsertLine(_T("\tgroup=TKIP"),3);
            tf.InsertLine(_T("\tpairwise=TKIP"),3);
            tf.InsertLine(_T("\tkey_mgmt=WPA-PSK"),3);
            tf.InsertLine(_T("\tproto=WPA"),3);
            tf.Write();
            tf.Close();

            sprintf(cFirOrder, "wpa_supplicant -Dwext -i%s -c /etc/wpa_supplicant/WIFI.conf -B", "ra0");
            system(cFirOrder);

            DhAllocateIP(adapterName);
        }
        break;
        case WLAN_AUTH_WPAPSK_AES:
        {
            fprintf(linuxAPI, "WLAN_AUTH_WPAPSK_AES\n");
            fflush(linuxAPI);
            const char* cKey = key.c_str();
            sprintf(cFirOrder, "wpa_passphrase %s %s > /etc/wpa_supplicant/WIFI.conf", ssid.c_str(), cKey);
            system(cFirOrder);

            wxTextFile tf(_T("/etc/wpa_supplicant/WIFI.conf"));
            tf.Open();
            tf.InsertLine(_T("ap_scan=2"),0);
            tf.InsertLine(_T("\tgroup=CCMP"),3);
            tf.InsertLine(_T("\tpairwise=CCMP"),3);
            tf.InsertLine(_T("\tkey_mgmt=WPA-PSK"),3);
            tf.InsertLine(_T("\tproto=WPA"),3);
            tf.Write();
            tf.Close();

            sprintf(cFirOrder, "wpa_supplicant -Dwext -i%s -c /etc/wpa_supplicant/WIFI.conf -B", "ra0");
            system(cFirOrder);

            DhAllocateIP(adapterName);
        }
        break;
        case WLAN_AUTH_WPA2PSK_TKIP:
        {
            fprintf(linuxAPI, "WLAN_AUTH_WPA2PSK_TKIP\n");
            fflush(linuxAPI);
            const char* cKey = key.c_str();
            sprintf(cFirOrder, "wpa_passphrase %s %s > /etc/wpa_supplicant/WIFI.conf", ssid.c_str(), cKey);
            system(cFirOrder);

            wxTextFile tf(_T("/etc/wpa_supplicant/WIFI.conf"));
            tf.Open();
            tf.InsertLine(_T("ap_scan=2"),0);
            tf.InsertLine(_T("\tgroup=TKIP"),3);
            tf.InsertLine(_T("\tpairwise=TKIP"),3);
            tf.InsertLine(_T("\tkey_mgmt=WPA-PSK"),3);
            tf.InsertLine(_T("\tproto=RSN"),3);
            tf.Write();
            tf.Close();

            sprintf(cFirOrder, "wpa_supplicant -Dwext -i%s -c /etc/wpa_supplicant/WIFI.conf -B", "ra0");
            system(cFirOrder);

            DhAllocateIP(adapterName);
        }
        break;
        case WLAN_AUTH_WPA2PSK_AES:
        {
            fprintf(linuxAPI, "WLAN_AUTH_WPA2PSK_AES\n");
            fflush(linuxAPI);
            const char* cKey = key.c_str();
            sprintf(cFirOrder, "wpa_passphrase %s %s > /etc/wpa_supplicant/WIFI.conf", ssid.c_str(), cKey);
            system(cFirOrder);

            wxTextFile tf(_T("/etc/wpa_supplicant/WIFI.conf"));
            tf.Open();
            tf.InsertLine(_T("ap_scan=2"),0);
            tf.InsertLine(_T("\tgroup=CCMP"),3);
            tf.InsertLine(_T("\tpairwise=CCMP"),3);
            tf.InsertLine(_T("\tkey_mgmt=WPA-PSK"),3);
            tf.InsertLine(_T("\tproto=RSN"),3);
            tf.Write();
            tf.Close();

            sprintf(cFirOrder, "wpa_supplicant -Dwext -i%s -c /etc/wpa_supplicant/WIFI.conf -B", "ra0");
            system(cFirOrder);

            DhAllocateIP(adapterName);
        }
        break;
        case WLAN_AUTH_OPEN_WEP:
        {
            fprintf(linuxAPI, "WLAN_AUTH_OPEN_WEP\n");
            fflush(linuxAPI);
//            system("killall wpa_supplicant");
//            sprintf(cFirOrder, "ifconfig %s up", name);
//            system(cFirOrder);
            const char* cKey = key.c_str();
//            sprintf(cFirOrder, "iwconfig %s essid any", name);
//            system(cFirOrder);
//            sprintf(cFirOrder, "iwlist %s scanning", name);
//            system(cFirOrder);
            sprintf(cFirOrder, "iwconfig %s key open %s [%d]", "ra0", cKey, auth >> 16);
            system(cFirOrder);
            sprintf(cFirOrder, "iwconfig %s essid \"%s\"", "ra0", ssid.c_str());
//            for (int i = 0; i < 10; i++)
//            {
                system(cFirOrder);
//            }
            DhAllocateIP(adapterName);
        }
        break;
        default:
        {
//            system("killall wpa_supplicant");
//            sprintf(cFirOrder, "ifconfig %s up", name);
//            system(cFirOrder);
//            sleep(1);
//            sprintf(cFirOrder, "iwconfig %s essid any", name);
//            system(cFirOrder);
//            sprintf(cFirOrder, "iwconfig %s essid any", name);
//            system(cFirOrder);
//            sprintf(cFirOrder, "iwlist %s scanning", name);
//            system(cFirOrder);
            fprintf(linuxAPI, "NONE\n");
            fflush(linuxAPI);
            sprintf(cFirOrder, "iwconfig %s key off", "ra0");
            system(cFirOrder);
            sprintf(cFirOrder, "iwconfig %s essid \"%s\"", "ra0", ssid.c_str());
            //for (int i = 0; i < 3; i++)
            //{
                system(cFirOrder);
            //}
            DhAllocateIP(adapterName);
        }
        break;
    }
    return true;
}

void LinuxNetworkAPI::DhAllocateIP(const string adapterName)
{
    fprintf(linuxAPI, "DhAllocateIP----> %s\n", adapterName.c_str());
    fflush(linuxAPI);
    char cFirOrder[ORDERBUFSIZE];
    sprintf(cFirOrder, "dhclient %s", adapterName.c_str());
    pthread_t thread_id;
    pthread_create(&thread_id, NULL, &ExecOrderThread, cFirOrder);
}

LinuxNetworkAPI::SearchThread::SearchThread(string name) : interface(name)
{
}

void LinuxNetworkAPI::SearchThread::OnExit()
{
}

void* LinuxNetworkAPI::SearchThread::Entry()
{
    FILE* dhclient = NULL;
    char cFirOrder[128];
    sprintf(cFirOrder, "dhclient %s", interface.c_str());
    system(cFirOrder);
    return NULL;
}

bool LinuxNetworkAPI::UpdateCurrentAP(const string adapterName, const string userPath,APStatus& apStatus)
{
    AccessPointList accessPointlist;
    memset(&accessPointlist, 0 ,sizeof(AccessPointList));
    //accessPointlist.apList = NULL;
    memset(&apStatus, 0, sizeof(APStatus));
    string ssid = GetSsid(userPath);
    memcpy(apStatus.ssid.ucSsid, ssid.c_str(), ssid.length());
    apStatus.ssid.length = ssid.length();
    if ( !ScanNetwork(adapterName,userPath,accessPointlist) )
    {
        return false;
    }
    for (size_t i = 0 ; i < accessPointlist.nCount ; i ++)
    {
        if ( accessPointlist.apList[i].ssid == apStatus.ssid )
        {
            apStatus = accessPointlist.apList[i];
            return true;
        }
    }
    return false;
}
bool LinuxNetworkAPI::StringToMacAddress(unsigned char* mac, const char* str, size_t strLen)
{
    if (str == NULL || mac == NULL || strLen < 17)
        return false;

    char* colon = ":";

    size_t index = 0;
    const char* first = str;
    const char* second = NULL;
    while (index < 6)
    {
        second = strstr(first, colon);
        unsigned char hex = 0;
        const char* p = first;
        int count = 0;
        while (count < 2)
        {
            char n = *p - '0';
            if (n > 9) n -= 7;
            hex = hex * 16 + n;
            p++;
            count++;
        }
        mac[index] = hex;
        index++;
        if (second != NULL)
        {
            first = strstr(second, colon);
            first++;
        }
    }
    return true;
}

bool operator == (const WlanSsid& ssid1, const WlanSsid& ssid2)
{
    bool result = true;
    result &= (ssid1.length == ssid2.length);
    for (size_t i = 0 ; i < AP_SSID_MAX_LENGTH ; i ++)
    {
        result &= (ssid1.ucSsid[i] == ssid2.ucSsid[i]);
    }
    return result;
}

bool LinuxNetworkAPI::IfUp(const wxArrayString& wxaAdapterList, string& currentAdapter)
{
    system("ifconfig -s > /tmp/ifup.txt");
    ifstream ifUp;
    string path = "/tmp/ifup.txt";
    ifUp.open(path.c_str(), ios_base::in);
    char ifUpBuf[1024] = {0};
    char name[128];
    int linecount = 1;
    wxArrayString temp;
    bool upFlag = false;
    while ( ifUp.getline(ifUpBuf, sizeof(ifUpBuf)) )
    {
        memset(name, '\0', 128);
        if ( 1 != linecount )
        {
            int i = 0;
            while (ifUpBuf[i] != ' ' &&  ifUpBuf[i] != '\t' &&  ifUpBuf[i] != '\n' &&  ifUpBuf[i] != '\0')
            {
                name[i] = ifUpBuf[i];
                i++;
            }
            temp.Add(wxString::FromUTF8((const char*)name));
        }
        linecount++;
    }
    ifUp.close();

    for (int j = 0; j < temp.Count(); j++)
    {
        for (int k = 0; k < wxaAdapterList.Count(); k++)
        {
            if ( wxaAdapterList[k].Cmp(temp[j]) == 0 )
            {
//                fprintf(linuxAPI, "currentAdapter is %s\n", currentAdapter.c_str());
//                fflush(linuxAPI);
                if ( currentAdapter.empty() || currentAdapter == "" || currentAdapter == "uselessPara" )
                {
                    currentAdapter = ENMUtil::WxStringToString(wxaAdapterList[k]);
                }
                else
                {
                    if ( currentAdapter != ENMUtil::WxStringToString(wxaAdapterList[k]) && currentAdapter != "uselessPara" )
                    {
//                        currentAdapter = ENMUtil::WxStringToString(wxaAdapterList[k]);
                    }
                }
                upFlag = true;
            }
        }
    }
    return upFlag;
}

bool LinuxNetworkAPI::IfLink(ENM_ADAPTER_TYPE adapterType, const wxArrayString& wxaAdapterList, const string userPath)
{
    bool bIfLink = false;
    if ( DCS_ADAPTER_WIRED == adapterType )
    {
        for (int k = 0; k < wxaAdapterList.Count(); k++)
        {
            char cOrder[128];
            sprintf(cOrder, "ethtool %s > /tmp/eth.txt", ENMUtil::WxStringToString(wxaAdapterList[k]).c_str());
            system(cOrder);
            ifstream in;
            string sPath = "/tmp/eth.txt";
            const char* cFileName = sPath.c_str();
            in.open(cFileName,ios_base::in);
            char cFileBuf[1024];
            wxString speed;
            while(in.getline(cFileBuf, sizeof(cFileBuf)))
            {
                wxString content = wxString::FromUTF8(cFileBuf);
                if ((int) content.find(wxT("Link detected:")) > 0)
                {
                    if ((int) content.find(wxT("yes")) > 0)
                    {
                        bIfLink = true;
                        break;
                    }
                }
            }
            in.close();
        }
    }
    else
    {
        for (int k = 0; k < wxaAdapterList.Count(); k++)
        {
            string name = "uselessPara";
            bool bIfUp = IfUp(wxaAdapterList, name);
            if ( bIfUp )
            {
//                char cOrder[128];
//                sprintf(cOrder, "ifconfig %s > /tmp/ifcForLink.txt", ENMUtil::WxStringToString(wxaAdapterList[k]).c_str());
//                system(cOrder);
//                ifstream in;
//                string sPath = "/tmp/ifcForLink.txt";
//                const char* cFileName = sPath.c_str();
//                in.open(cFileName,ios_base::in);
//                char cFileBuf[1024];
//                wxString IP;
//                while(in.getline(cFileBuf, sizeof(cFileBuf)))
//                {
//                    wxString content = wxString::FromUTF8(cFileBuf);
//                    if ((int) content.find(wxT("inet addr:")) > 0)
//                    {
//                        size_t posBegin = content.Find(wxT("inet addr:")) + 10;
//                        size_t posEnd = content.Find(wxT("Bcast:")) - 2;
//                        int len = posEnd - posBegin;
//                        IP = content.Mid(posBegin, len);
//                        string ip = ENMUtil::WxStringToString(IP);
//                        if ( ip != "127.0.0.1" && !ip.empty() )
//                        {
//                            in.close();
//                            bIfLink = true;
//                            break;
//                        }
//                    }
//                }
//                in.close();
                string ip = GetIP(ENMUtil::WxStringToString(wxaAdapterList[k]).c_str());
                if ( ip != "127.0.0.1" && !ip.empty() )
                {
                    bIfLink = true;
                    break;
                }
            }
        }
    }
    return bIfLink;
}

bool LinuxNetworkAPI::Enable8021xAuthentication(bool enable)
{
//	fprintf(linuxAPI, "Enable8021xAuthentication Flag %d\n",enable);
    vector<string> vInit;
    vector<string> vDefault;
    wxString wxStr = _T("/usr/sbin/xsupplicant");
    if ( !wxFile::Exists(wxStr) )
    {
        return false;
    }
    ifstream finInit("/etc/init.d/xsupplicant");
    do
    {
        string s;
        getline(finInit, s);
        vInit.push_back(s);
    }
    while ( !finInit.eof() );
    finInit.close();

    ifstream finDefault("/etc/default/xsupplicant");
    do
    {
        string s;
        getline(finDefault, s);
        vDefault.push_back(s);
    }
    while ( !finDefault.eof() );
    finDefault.close();

    ofstream foutInit("/etc/init.d/xsupplicant");
    ofstream foutDefault("/etc/default/xsupplicant");
    vector<string>::size_type i;
    for ( i = 0; i < vInit.size(); i++ )
    {
        if ( string::npos != vInit.at(i).find("ENABLED=") )
        {
            if ( enable )
            {
                vInit.at(i) = "ENABLED=1";
            }
            else
            {
                vInit.at(i) = "ENABLED=0";
            }

        }
        if ( i != vInit.size() - 1 )
        {
            foutInit << vInit.at(i) << endl;
        }
        else
        {
            foutInit << vInit.at(i);
        }
    }
    for ( i = 0; i < vDefault.size(); i++ )
    {
        if ( string::npos != vDefault.at(i).find("ENABLED=") )
        {
            if ( enable )
            {
                vDefault.at(i) = "ENABLED=1";
            }
            else
            {
                vDefault.at(i) = "ENABLED=0";
            }
        }
        if ( i != vDefault.size() - 1 )
        {
            foutDefault << vDefault.at(i) << endl;
        }
        else
        {
            foutDefault << vDefault.at(i);
        }
    }
    finInit.close();
    foutDefault.close();
    if ( enable )
    {
        system("gksu /etc/init.d/xsupplicant start");
    }
    else
    {
        system("gksu /etc/init.d/xsupplicant stop");
    }
//    fflush(linuxAPI);
    return true;
}

bool LinuxNetworkAPI::EnableInternetSharing(bool enable)
{
    fprintf(linuxAPI, "Enter LinuxNetworkAPI EnableInternetSharing \n");
	fprintf(linuxAPI, "EnableInternetSharing Flag %d\n",enable);
    fflush(linuxAPI);
    if ( enable )
    {
        system("sysctl -w net.ipv4.ip_forward=1");
    }
    else
    {
        system("sysctl -w net.ipv4.ip_forward=0");
    }
    return true;
}

bool LinuxNetworkAPI::OverwriteHomePage(ENM_String strHomePage, const string userPath)
{
//	fprintf(linuxAPI, "Enter LinuxNetworkAPI overwrite homepage \n");
//	fprintf(linuxAPI, "overwrite homepage %s\n",strHomePage.dcsString);
//    fflush(linuxAPI);
    wxString wxstrHomePage = wxString::FromUTF8((const char*)strHomePage.dcsString);

    wxString prefsFile = GetFirefoxConfigFile(userPath);
//    fprintf(linuxAPI, "prefsFile is %s\n", ENMUtil::WxStringToString(prefsFile).c_str());
//    fflush(linuxAPI);
    if ( prefsFile.Length() == 0 || !wxFile::Exists(prefsFile) )
        return false;
    wxArrayString arrayString;
//    const char* fileName = WxStringToString(prefsFile).c_str();
    char fileName[256] = { 0 };
    strcpy(fileName, prefsFile.mb_str());
    ifstream fin(fileName);
    bool homePageFound = false;
    while ( !fin.eof() )
    {
        char buf[256] = { 0 };
        fin.getline(buf, 256);
        wxString s = wxString::FromUTF8(buf);
        if ( s.StartsWith(_T("user_pref(\"browser.startup.homepage\", \"")) )
        {
            homePageFound = true;
            s = _T("user_pref(\"browser.startup.homepage\", \"") + wxstrHomePage + _T("\");");
        }
        arrayString.Add(s);
    }
    fin.close();
    if ( !homePageFound )
    {
        wxString wxsHomePage = _T("user_pref(\"browser.startup.homepage\", \"") + wxstrHomePage + _T("\");");
        arrayString.Add(wxsHomePage);
    }
    ofstream fout(fileName);
    size_t i;
    for ( i = 0; i < arrayString.Count() - 1; i++ )
    {
        fout << ENMUtil::WxStringToString(arrayString.Item(i)) << endl;
    }
    fout << ENMUtil::WxStringToString(arrayString.Item(i)) << endl;
    fout.close();
    return true;
}

wxString LinuxNetworkAPI::GetFirefoxConfigFile(const string userPath)
{
    wxString firefoxDir = ENMUtil::StringToWxString(userPath) + _T("/.mozilla/firefox");
    wxString profile = firefoxDir + _T("/profiles.ini");
    if ( !wxFile::Exists(profile) )
        return _T("");

    ifstream fin(ENMUtil::WxStringToString(profile).c_str());
    wxArrayString arrayString;
    while ( !fin.eof() )
    {
        char buf[256] = { 0 };
    //    getline(fin, buf);
        fin.getline(buf, 256);
        arrayString.Add(wxString::FromUTF8(buf));
    }
    fin.close();
    wxString pref;
    for ( size_t i = 0; i < arrayString.Count(); i++ )
    {
        wxString s = arrayString.Item(i);
        if ( s.StartsWith(_T("Path=")) )
        {
            pref = s.Mid(s.Find('=', false) + 1);
        }
    }
    return ::wxGetHomeDir() + _T("/.mozilla/firefox/") + pref + _T("/prefs.js");
}

bool LinuxNetworkAPI::OverwriteProxy(ENM_ProxyInfo proxyInfo, const string userPath)
{
//	fprintf(linuxAPI, "Enter LinuxNetworkAPI overwrite proxy \n");
//	fprintf(linuxAPI, "overwrite proxy %s\n",proxyInfo.host.dcsString);
//	fprintf(linuxAPI, "overwrite proxy %s\n",proxyInfo.port.dcsString);
//    fflush(linuxAPI);
    wxString wxstrProxy = wxString::FromUTF8((const char*)proxyInfo.host.dcsString);
    wxString wxstrPort = wxString::FromUTF8((const char*)proxyInfo.port.dcsString);

    wxString prefsFile = GetFirefoxConfigFile(userPath);
    if ( prefsFile.Length() == 0 || !wxFile::Exists(prefsFile) )
        return false;
    wxArrayString arrayString;
//    const char* fileName = WxStringToString(prefsFile).c_str();
    bool proxyFound = false;
    bool portFound = false;
    char fileName[256] = { 0 };
    strcpy(fileName, prefsFile.mb_str());
    ifstream fin(fileName);
    while ( !fin.eof() )
    {
        char buf[256] = { 0 };
        fin.getline(buf, 256);
        wxString s = wxString::FromUTF8(buf);
        if ( s.StartsWith(_T("user_pref(\"network.proxy.http\", \"")) )
        {
            proxyFound = true;
            s = _T("user_pref(\"network.proxy.http\", \"") + wxstrProxy + _T("\");");
        }
        else if ( s.StartsWith(_T("user_pref(\"network.proxy.http_port\", ")) )
        {
            portFound = true;
            s = _T("user_pref(\"network.proxy.http_port\", ") + wxstrPort + _T(");");
        }
        arrayString.Add(s);
    }
    fin.close();
    if ( !proxyFound )
    {
        wxString proxy = _T("user_pref(\"network.proxy.http\", \"") + wxstrProxy + _T("\");");
        arrayString.Add(proxy);
    }
    if ( !portFound )
    {
        wxString port = _T("user_pref(\"network.proxy.http_port\", ") + wxstrPort + _T(");");
        arrayString.Add(port);
    }
    ofstream fout(fileName);
    size_t i;
    for ( i = 0; i < arrayString.Count() - 1; i++ )
    {
        fout << ENMUtil::WxStringToString(arrayString.Item(i)) << endl;
    }
    fout << ENMUtil::WxStringToString(arrayString.Item(i)) << endl;
    fout.close();
    return true;
}

//    bool GetNeighborsInfo(PENM_NEIGHBORS_INFO* pNeighborsInfo);

bool LinuxNetworkAPI::ChangeAddress(ENM_AddressInfo addressInfo)
{
	if (wxFileExists(_T("/etc/resolv.conf")))
	{
//        vector<string> vDns;
//        ifstream finDns("/etc/resolv.conf");
//        bool rep = true;
//        do
//        {
//            string s;
//            getline(finDns, s);
//            if ( string::npos != s.find("nameserver ") && rep )
//            {
//                vDns.push_back("nameserver " + string((const char*)addressInfo.dns.dcsString));
//                rep = false;
//            }
//            vDns.push_back(s);
//        }
//        while ( !finDns.eof() );
//        if ( rep )
//        {
//            vDns.push_back("nameserver " + string((const char*)addressInfo.dns.dcsString));
//        }
//        finDns.close();
//
//        ofstream foutDns("/etc/resolv.conf");
//        vector<string>::size_type i;
//        for ( i = 0; i < vDns.size(); i++ )
//        {
//            if ( i != vDns.size() - 1 )
//            {
//                foutDns << vDns.at(i) << endl;
//            }
//            else
//            {
//                foutDns << vDns.at(i);
//            }
//        }
//        foutDns.close();
        wxTextFile tf;
        tf.Open(_T("/etc/resolv.conf"));
        tf.Clear();
        wxString str = _T("nameserver ")  + ENMUtil::StringToWxString(string((const char*)addressInfo.dns.dcsString));
        tf.InsertLine(str, 0);
        tf.Write();
        tf.Close();
    }
    else
    {
        wxTextFile tf;
        tf.Create(_T("/etc/resolv.conf"));
        wxString str = _T("nameserver ")  + ENMUtil::StringToWxString(string((const char*)addressInfo.dns.dcsString));
        tf.InsertLine(str, 0);
        tf.Write();
        tf.Close();
    }

    wxTextFile tf;
    tf.Open(_T("/etc/network/interfaces"));
    tf.Clear();

    tf.AddLine(_T("auto lo"));
    tf.AddLine(_T("iface lo inet loopback"));
    tf.AddLine(_T("auto ") + wxString::FromUTF8((const char*)addressInfo.adapterInfo.userName.dcsString));
    tf.AddLine(_T("iface ") + wxString::FromUTF8((const char*)addressInfo.adapterInfo.userName.dcsString) + _T(" inet static"));
    tf.AddLine(_T("address ") + wxString::FromUTF8((const char*)addressInfo.ip.dcsString));
    tf.AddLine(_T("netmask ") + wxString::FromUTF8((const char*)addressInfo.mask.dcsString));
    tf.AddLine(_T("gateway ") + wxString::FromUTF8((const char*)addressInfo.gateway.dcsString));
    tf.Write();
    tf.Close();

    string ipold = GetIP(string((char*)addressInfo.adapterInfo.userName.dcsString));
    string ifname = string((char*)addressInfo.adapterInfo.userName.dcsString);
    string releaseIp = "ip addr del " + ipold+ " dev " + ifname;
    system(releaseIp.c_str());
    system("/etc/init.d/networking restart");

    fprintf(linuxAPI, "Leave LinuxNetworkAPI addressInfo \n");
    fflush(linuxAPI);
    return true;
}

void LinuxNetworkAPI::ExecSmbtree()
{
    system("killall wpa_supplicant");
}

void LinuxNetworkAPI::ExecNmblookup(ENM_StringW strHostName, const string adapterName)
{
    wxString fileName((wchar_t*)strHostName.dcsStringW);
    if ( _T("killall") == fileName )
    {
        system("killall dhclient");
    }
    else if ( _T("connect") == fileName )
    {
        string strOrder = "wpa_supplicant -Dwext -i" + adapterName + " -c /etc/wpa_supplicant/WIFI.conf -B";
        fprintf(linuxAPI, "connect in ExecNmblookup----> %s\n", strOrder.c_str());
        fflush(linuxAPI);
        pthread_t thread_id;
        pthread_create(&thread_id, NULL, &ExecOrderThread, (void*)strOrder.c_str());
        DhAllocateIP(adapterName);
    }
    else if ( fileName.find(_T("/tmp/enm")) != wxNOT_FOUND )
    {
        string strCp = "cp " + ENMUtil::WxStringToString(fileName) + " /etc/Network\\ Neighborhood";
        fprintf(linuxAPI, "cp in ExecNmblookup----> %s\n", strCp.c_str());
        fflush(linuxAPI);
        system(strCp.c_str());
    }
    else if ( _T("dhclient") == fileName )
    {
        string strDhcp = "ifconfig " + adapterName + " 127.0.0.1";
        system(strDhcp.c_str());
        DhAllocateIP(adapterName);
    }
    else if ( _T("dhcp") == fileName )
    {
        string strDhcp = "ifconfig " + adapterName + " 127.0.0.1";
        system(strDhcp.c_str());
        fprintf(linuxAPI, "enter:ExecNmblookup:wdhclient");
        fflush(linuxAPI);
            wxTextFile tf;
            tf.Open(_T("/etc/network/interfaces"));
            tf.Clear();
            tf.AddLine(_T("auto lo"));
            tf.AddLine(_T("iface lo inet loopback"));
            tf.AddLine(_T("auto ") + ENMUtil::StringToWxString(adapterName));
            tf.AddLine(_T("iface ") + ENMUtil::StringToWxString(adapterName) + _T(" inet dhcp"));
            tf.Write();
            tf.Close();
            string strOrder = "/etc/init.d/networking restart";
            pthread_t thread_id;
            pthread_create(&thread_id, NULL, &ExecOrderThread, (void*)strOrder.c_str());
    }
    else if ( _T("releaseip") == fileName )
    {
        string releaseIp = "ip addr del " + GetIP(adapterName) + " dev " + adapterName;
        fprintf(linuxAPI, "---->%s", releaseIp.c_str());
        fflush(linuxAPI);
        system(releaseIp.c_str());
    }
    else if ( _T("setip") == fileName )
    {
        fprintf(linuxAPI, "enter:ExecNmblookup:setip");
        fflush(linuxAPI);
        string strCp = "ifconfig " + adapterName + " 127.0.0.1";
        system(strCp.c_str());
    }
    else if ( _T("rmSuspend") == fileName )
    {
        string removeFile = "rm /tmp/.suspend";
        system(removeFile.c_str());
    }
    else if ( _T("rmResume") == fileName )
    {
        string removeFile = "rm /tmp/.resume";
        system(removeFile.c_str());
    }
    else
    {
        string strUpAdapter = "ifconfig " + adapterName + " up";
        fprintf(linuxAPI, "disconnect in ExecNmblookup----> %s\n", strUpAdapter.c_str());
        fflush(linuxAPI);
        system(strUpAdapter.c_str());
    }

}

string LinuxNetworkAPI::GetIP(string ifname)
{
    struct ifreq ifr;
    struct sockaddr_in sin;
    int socket_id;
    socket_id = socket(AF_INET, SOCK_DGRAM, 0);
    if(socket_id < 0)
    {
        return "";
    }
    char* ip = new char[32];
    memset(ip, 0 ,32);
    strncpy (ifr.ifr_name, ifname.c_str(), IFNAMSIZ);
    if ( ioctl(socket_id, SIOCGIFADDR, &ifr) == 0)
    {
        memcpy (&sin, &(ifr.ifr_addr), sizeof (sin));
        memcpy(ip, (char*)inet_ntoa (sin.sin_addr), strlen((char*)inet_ntoa (sin.sin_addr)));
    }
    close(socket_id);

    return string(ip);
}
bool LinuxNetworkAPI::DeleteProfile(ENM_StringW strFileName)
{
    wxString fileName((wchar_t*)strFileName.dcsStringW);
    return ::wxRemoveFile(fileName);

}
