/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * In addition, as a special exception, Intel gives permission to link
 * the code of portions of this program with the OpenSSL project's
 * "OpenSSL" library (or with modified versions of it that use the same
 * license as the "OpenSSL" library), and distribute the linked
 * executables.  You must obey the GNU General Public License in all
 * respects for all of the code used other than "OpenSSL".  If you modify
 * this file, you may extend this exception to your version of the file,
 * but you are not obligated to do so.  If you do not wish to do so,
 * delete this exception statement from your version.
 */

#ifndef _SUPPLIER_MANAGER_H_
#define _SUPPLIER_MANAGER_H_
#include "DCSCommon.h"
#include "DcsPlugin.h"
#include "ConnMgmt.h"
#include <map>
#include <vector>
using namespace std;

#ifdef UNIT_TEST
#include "TestSupplierManager.h"
#endif

#define MAX_EVENT_NUM 32

#ifdef _WIN32
typedef HINSTANCE LIB_HANDLE;
#else
typedef void* LIB_HANDLE;
#endif

typedef struct Module_Library_Info_S{
	int ID;
	LIB_HANDLE lib;     /**<  Handle to shared lib file   */
	DCS_Return_Code (*funcHandler)(DCS_RequestData* pData);
	int (*unInit)();
	map<DCS_Socket, int >  clientRegisteredEventTbl;
	//int registeredEvents; /* if the little n bit is set to 1, it means event id n is registered, otherwise not registered, 0x03 means event ID 0 and 1 is registered.*/
}Module_Library_Info;

class SupplierManager{
#ifdef UNIT_TEST
	friend class TestSupplierManager;
#endif
protected:
	SupplierManager();
public:
	~SupplierManager();
	static SupplierManager* Instance();
	int UnInit();/**<unload the module*/
	/** handle unregister event,  remove the module/event from the registered event table */
	int HandleUnregisterEvent(DCS_Socket clifd, int moduleID, int eventID);

	/** handle event,  record the module/event into the registered event table */
	int HandleEvent(DCS_Socket clifd, int moduleID, int eventID);
	/** check if event is registered,see if it's in the registered event table */
	BOOL CheckEvent(DCS_Socket clifd, int moduleID, int eventID);
	
	/** handle function request, function id is of type Module_Operation */
	int HandleFuncRequest(DCS_Socket clifd, int moduleID, DCS_RequestData* pData);

	/** the client is closed, remove its registered events*/
	int RemoveClient(DCS_Socket clifd);
    static BOOL IsInitialized(); // judge if all plugins are loaded
private:
	/**traverse the designated directory, and load the modules, 
	 * only those plugins that provide the following interfaces are loaded:
	 * "DP_GetModuleID", "DP_Initialize", "DP_Uninitialize", "DP_HandleRequest", "DP_GetDescription" 
	 *	call the interface to get the module ID, and Initialize the library.
	 *  Document the module ID into the loadedModuleIDs table.
	 */
	int Init(); 
	
	int HandlePolicy(int funcID, PVOID params,size_t paramsLen, PVOID pReturnData, size_t* pReturnDataLen);
#ifdef _WIN32
	void ScanDir(TCHAR   *path, TCHAR * files[], int* filenum);
#else
       void ScanDir(const char   *path, char * files[], int* filenum);

#endif
	static SupplierManager* pInstance;
	/** registered event table, the index is module ID, and */
	int loadedModuleNum;/**< loaded module number*/
	Module_Library_Info loadedModuleInfo[MAX_MODULE_NUM];/**< loaded module ID table*/
#ifdef _WIN32
	HANDLE m_hMutex;
#endif
    static BOOL initialized;
    int accelRegisteredClientNum;
	int Lock();
	int Unlock();
};

#endif
