/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by
 *              Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include "config.h"
#include <glib.h>
#include <glib-object.h>

#include <gtx.h>
#include <dee.h>

/* Joins an existing model, and then tries to define the column types,
 * and add two rows with these types */
gint
main (gint argc, gchar *argv[])
{
  DeeModel     *model;
  
  g_type_init (); 
  g_thread_init (NULL);
  dbus_g_thread_init ();

  model = dee_shared_model_new (argv[1], 2, G_TYPE_INT, G_TYPE_STRING);
  dee_shared_model_connect (DEE_SHARED_MODEL (model));

  if (gtx_wait_for_signal (G_OBJECT (model), 300, "ready"))
    {
      g_critical ("Model never emitted 'ready' signal");
      return 1;
    }
  
  dee_model_append (model, 0, 27, 1, "skunkworks", -1);
  dee_model_append (model, 0, 68, 1, "wumbo", -1);

  gtx_yield_main_loop (500);
  
  return 0;
}