/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibGLib" ];

const Cu = Components.utils;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://androidaccountsync/libgobject-ctypes.jsm");


XPCOMUtils.defineLazyGetter(this, "GVariant", function() {
  return ctypes.StructType("GVariant");
});

XPCOMUtils.defineLazyGetter(this, "gchar", function() {
  return ctypes.char;
});

XPCOMUtils.defineLazyGetter(this, "glong", function() {
  return ctypes.long;
});

XPCOMUtils.defineLazyGetter(this, "gulong", function() {
  return ctypes.unsigned_long;
});

XPCOMUtils.defineLazyGetter(this, "gint", function() {
  return ctypes.int;
});

XPCOMUtils.defineLazyGetter(this, "guint", function() {
  return ctypes.unsigned_int;
});

XPCOMUtils.defineLazyGetter(this, "gpointer", function() {
  return ctypes.voidptr_t;
});

XPCOMUtils.defineLazyGetter(this, "GClosureNotify", function() {
  return ctypes.voidptr_t;
});

XPCOMUtils.defineLazyGetter(this, "GCallback", function() {
  return ctypes.voidptr_t;
});


XPCOMUtils.defineLazyGetter(this, "GConnectFlags", function() {
  return ctypes.unsigned_int;
});

XPCOMUtils.defineLazyGetter(this, "g_signal_connect_data", function() {
  var g_signal_connect_data =
    libgobject.declare("g_signal_connect_data",
                       ctypes.default_abi,
                       gulong,
                       gpointer,
                       gchar.ptr,
                       GCallback,
                       gpointer,
                       GClosureNotify,
                       GConnectFlags);
  if (!g_signal_connect_data)
    throw "g_signal_connect_data is unavailable";

  return g_signal_connect_data;
});

XPCOMUtils.defineLazyGetter(this, "g_variant_get_string", function() {
  var g_variant_get_string =
    libgobject.declare("g_variant_get_string",
                        ctypes.default_abi,                        
                        gchar.ptr,
                        GVariant.ptr,
                        gint.ptr);
  if (!g_variant_get_string) {
    dump("g_variant_get_string is unavailable\n");
    throw "g_variant_get_string is unavailable";
  }

  return g_variant_get_string;
});

XPCOMUtils.defineLazyGetter(this, "g_variant_get_int32", function() {
  var g_variant_get_int32=
    libgobject.declare("g_variant_get_int32",
                        ctypes.default_abi,                        
                        gint,
                        GVariant.ptr);
  if (!g_variant_get_int32)
    throw "g_variant_get_int32 is unavailable";

  return g_variant_get_int32;
});

XPCOMUtils.defineLazyGetter(this, "g_variant_new_int32", function() {
  var g_variant_new_int32=
    libgobject.declare("g_variant_new_int32",
                        ctypes.default_abi,
                        GVariant.ptr,                        
                        gint);
  if (!g_variant_new_int32)
    throw "g_variant_get_int32 is unavailable";

  return g_variant_new_int32;
});


XPCOMUtils.defineLazyGetter(this, "g_variant_new_string", function() {
  var g_variant_new_string =
    libgobject.declare("g_variant_new_string",
                        ctypes.default_abi,
                        GVariant.ptr,                        
                        gchar.ptr);
  if (!g_variant_new_string)
    throw "g_variant_new_string is unavailable";

  return g_variant_new_string;
});

XPCOMUtils.defineLazyGetter(this, "g_variant_unref", function() {
  var g_variant_unref =
    libgobject.declare("g_variant_unref",
                        ctypes.default_abi,                        
                        ctypes.void_t,
                        GVariant.ptr);
  if (!g_variant_unref)
    throw "g_variant_unref is unavailable";

  return g_variant_unref;
});


var LibGLib = {
  GVariant: GVariant,
  GCallback: GCallback,
  GClosureNotify: GClosureNotify,
  GConnectFlags: GConnectFlags,
  gchar: gchar,
  guint: guint,
  gulong: gulong,
  glong: glong,
  gpointer: gpointer,

  g_signal_connect: function GLIB_g_signal_connect(instance,
                                                  detailed_signal,
                                                  handler,
                                                  data)
  {
    return g_signal_connect_data(instance, detailed_signal,
                                 handler, data, null, 0);
  },

  g_variant_get_string: function GLIB_g_variant_get_string(variant)
  {
    return g_variant_get_string(variant, null);
  },

  g_variant_get_int32: function GLIB_g_variant_get_int32(variant)
  {
    return g_variant_get_int32(variant);
  },

  g_variant_new_int32: function GLIB_g_variant_new_int32(val)
  {
    return g_variant_new_int32(val);
  },

  g_variant_new_string: function GLIB_g_variant_new_string(val)
  {
    return g_variant_new_string(val);
  },

  g_variant_unref: function GLIB_g_variant_unref(val)
  {
    g_variant_unref(val);
  },

}

